<?php
session_start();
require '../config/db.php';
if(!isset($_SESSION['manager_id'])) die('Unauthorized');

$dept = strtolower($_SESSION['department']);
$table = $dept.'_manager_leaves';

/* ===== PAGE TITLE ===== */
$page_title = ucfirst($dept) . " Manager • Apply Leave";

/* ===== LAYOUT START ===== */
include 'assets/layout_top.php';
?>
<br><br>
<div class="glass-panel p-4">

<div class="glass-card mx-auto" style="max-width:600px;">
    <h4 class="mb-3 text-center">
        <i class="fa-solid fa-calendar-days me-2"></i>Manager Leave Request
    </h4>

    <form method="POST" action="save_manager_leave.php" class="row g-3">

        <div class="col-12">
            <label>Leave Date</label>
            <input type="date" name="leave_date" class="form-control" required>
        </div>

        <div class="col-12">
            <label>Reason</label>
            <textarea name="reason" class="form-control" rows="4" required></textarea>
        </div>

        <div class="col-12">
            <button class="btn-main w-100 mt-2">
                <i class="fa-solid fa-paper-plane me-1"></i> Submit Leave
            </button>
        </div>

    </form>
</div>

</div>

<?php
/* ===== LAYOUT END ===== */
include 'assets/layout_bottom.php';
?>
