<?php
session_start();
require 'config/db.php';

function blockIfCompleted(PDO $pdo, $project_id){
    $stmt = $pdo->prepare("SELECT status FROM projects WHERE id=?");
    $stmt->execute([$project_id]);
    $status = $stmt->fetchColumn();

    if($status === 'Completed'){
        die('This project is already completed and cannot be modified.');
    }
}

if(!isset($_SESSION['employee_id'])) die('Unauthorized');

/* SEND TO DESIGNER */
if(isset($_POST['send'])){
    $pid = $_POST['project_id'];

    $pdo->prepare("
        UPDATE projects
        SET status='SentToDesigner'
        WHERE id=? AND sales_id=?
    ")->execute([$pid,$_SESSION['employee_id']]);

    $pdo->prepare("
        INSERT INTO project_actions
        (project_id, action_by, action)
        VALUES (?,?,?)
    ")->execute([
        $pid,
        'Sales',
        'Project sent to designer manager'
    ]);
}

/* FETCH APPROVED PROJECTS */
$stmt = $pdo->prepare("
    SELECT * FROM projects
    WHERE sales_id=? AND status='Approved'
    ORDER BY created_at DESC
");
$stmt->execute([$_SESSION['employee_id']]);
$projects = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="assets/style.css">

<style>
/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}

/* Glass panel */
.glass-panel{
  max-width:900px;
  margin:60px auto;
  padding:25px;
  background:rgba(255,255,255,.08);
  backdrop-filter:blur(22px);
  border-radius:18px;
  border:1px solid rgba(255,255,255,.14);
  box-shadow:0 12px 35px rgba(0,151,252,.25);
  color:#fff;
}

/* Table styling */
.table thead th{
    background:rgba(0,0,0,.3);
    color:#fff;
}
.table tbody td{
    vertical-align:middle;
    color:black;
}
.badge-success{background:#28a745}
.btn-main{
    background:linear-gradient(135deg,#0097fc,#ff6a00);
    border:none;
    color:#fff;
    font-weight:600;
    padding:6px 12px;
    transition:.3s;
}
.btn-main:hover{
    transform:translateY(-2px);
    box-shadow:0 0 25px rgba(255,138,0,.6);
}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<!-- ===== HEADER ===== -->
<?php include 'assets/header.php'; ?>
<br><br>
<div class="glass-panel">

<h3 class="mb-4 text-center">Approved Projects</h3>

<table class="table table-bordered table-hover">
<thead>
<tr>
<th>Client</th>
<th>Title</th>
<th>Price</th>
<th>Status</th>
<th>Action</th>
</tr>
</thead>
<tbody>

<?php foreach($projects as $p): ?>
<tr>
<td><?= htmlspecialchars($p['client_name']) ?></td>
<td><?= htmlspecialchars($p['title']) ?></td>
<td>$<?= number_format($p['price'],2) ?></td>
<td><span class="badge badge-success"><?= $p['status'] ?></span></td>
<td>
<form method="POST">
<input type="hidden" name="project_id" value="<?= $p['id'] ?>">
<button name="send" class="btn-main btn-sm">Send to Designer</button>
</form>
</td>
</tr>
<?php endforeach; ?>

<?php if(!$projects): ?>
<tr><td colspan="5" class="text-center">No approved projects</td></tr>
<?php endif; ?>

</tbody>
</table>
</div>

<script src="assets/particles.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
