<?php
session_start();
require 'config/db.php';

if(!isset($_SESSION['employee_id'])) die('Unauthorized');

/* ===============================
   FETCH COMPLETED PROJECTS ONLY
================================ */
$projects = $pdo->query("
    SELECT * FROM projects
    WHERE status='Completed'
    ORDER BY created_at DESC
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="assets/style.css">

<style>
/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}

/* Glass panel for table */
.glass-panel{
  background:rgba(255,255,255,.08);
  backdrop-filter:blur(22px);
  border-radius:18px;
  border:1px solid rgba(255,255,255,.14);
  box-shadow:0 12px 35px rgba(0,151,252,.25);
  padding:20px;
  margin-top:30px;
  color:#fff;
}

/* Table styling */
.table th,.table td{text-align:center;vertical-align:middle;}
.table th{background:rgba(0,0,0,.3)}
.badge{font-size:13px}
.table th{
color:white;
}
.table td{
color:black;
}
/* Log box */
.log-box{
  background:rgba(0,0,0,.35);
  padding:12px;
  border-left:4px solid #28a745;
  border-radius:6px;
}
.log-row{
  padding:6px 0;
  font-size:14px;
  border-bottom:1px dashed rgba(255,255,255,.2);
}
.log-row:last-child{border-bottom:none}
.view-log{cursor:pointer;color:#00bfff}
.view-log:hover{text-decoration:underline}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<!-- ===== HEADER ===== -->
<?php include 'assets/header.php'; ?>

<div class="container">

<h3 class="text-center mt-4 mb-3">Completed Projects</h3>

<?php if(!$projects): ?>
<div class="alert alert-info text-dark">No completed projects found</div>
<?php else: ?>
<div class="glass-panel">
<table class="table table-bordered table-hover mb-0">
<thead>
<tr>
<th>ID</th>
<th>Client</th>
<th>Sales</th>
<th>Designer</th>
<th>Title</th>
<th>Price</th>
<th>Tip</th>
<th>Completed On</th>
<th>History</th>
</tr>
</thead>
<tbody>
<?php foreach($projects as $p): ?>
<tr>
<td><?= $p['id'] ?></td>
<td>
<b><?= htmlspecialchars($p['client_name']) ?></b><br>
<small><?= htmlspecialchars($p['client_email']) ?></small><br>
<small><?= htmlspecialchars($p['client_phone']) ?></small>
</td>
<td><?= $p['sales_name'] ?></td>
<td><?= $p['designer_name'] ?></td>
<td>
<b><?= htmlspecialchars($p['title']) ?></b><br>
<small><?= htmlspecialchars($p['description']) ?></small>
</td>
<td>$<?= number_format($p['price'],2) ?></td>
<td class="text-success">$<?= number_format($p['tip_amount'],2) ?></td>
<td><?= date('d M Y H:i', strtotime($p['created_at'])) ?></td>
<td>
<span class="view-log" data-id="<?= $p['id'] ?>">View Actions</span>
</td>
</tr>

<tr id="log<?= $p['id'] ?>" style="display:none">
<td colspan="9">
<div class="log-box">
<?php
$actions = $pdo->prepare("SELECT * FROM project_actions WHERE project_id=? ORDER BY created_at ASC");
$actions->execute([$p['id']]);
foreach($actions as $a):
?>
<div class="log-row">
<b><?= htmlspecialchars($a['action_by']) ?>:</b>
<?= htmlspecialchars($a['action']) ?>
<span class="float-end text-white-50"><?= date('d M Y H:i', strtotime($a['created_at'])) ?></span>
</div>
<?php endforeach; ?>
</div>
</td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
</div>
<?php endif; ?>

</div>

<script>
document.querySelectorAll('.view-log').forEach(btn=>{
    btn.onclick=()=>{
        const row=document.getElementById('log'+btn.dataset.id);
        row.style.display=row.style.display==='none'?'table-row':'none';
    }
});
</script>

<script src="assets/particles.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
