<?php
session_start();
require 'config/db.php';

$error = '';

if ($_POST) {
    $stmt = $pdo->prepare("SELECT * FROM sales_employees WHERE email=? AND status=1");
    $stmt->execute([$_POST['email']]);
    $emp = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($emp && $emp['password'] && password_verify($_POST['password'], $emp['password'])) {
        session_regenerate_id(true);
        $_SESSION['employee_id'] = $emp['id'];
        $_SESSION['employee_name'] = $emp['full_name'];
        $_SESSION['department'] = 'Sales';

        $pdo->prepare("
            INSERT INTO sales_employees_login_logs
            (employee_id, login_date, login_time, ip_address)
            VALUES (?, CURDATE(), CURTIME(), ?)
        ")->execute([$emp['id'], $_SERVER['REMOTE_ADDR']]);

        header("Location: dashboard.php");
        exit;
    }

    if ($emp && $emp['password'] === NULL) {
        $_SESSION['set_pass_id'] = $emp['id'];
        header("Location: set_password.php");
        exit;
    }

    $error = "Invalid email or password";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
:root{
 
  --glass:rgba(255,255,255,.08);
}

*{margin:0;padding:0;box-sizing:border-box;font-family:Inter,Segoe UI,Arial,sans-serif}
body{;color:#fff;min-height:100vh;overflow-x:hidden;display:flex;align-items:center;justify-content:center;}

/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

/* Grid */
.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}
@keyframes grid{to{transform:translateY(70px)}}

/* Glass login card */
.card-login{
    width:100%;
    max-width:400px;
    padding:30px;
    border-radius:18px;
    background:var(--glass);
    backdrop-filter:blur(22px);
    border:1px solid rgba(255,255,255,.14);
    box-shadow:0 12px 35px rgba(0,151,252,.25);
}

/* Inputs */
.form-control{
    background:rgba(0,0,0,.35);
    border:1px solid rgba(255,255,255,.15);
    color:#fff;
}
.form-control:focus{
    border-color:var(--blue);
    box-shadow:0 0 0 1px var(--blue),0 0 18px rgba(0,151,252,.45);
    background:rgba(0,0,0,.4);
    color:#fff;
}

/* Labels */
label{font-size:13px;opacity:.8;color:#fff}

/* Button */
.btn-main{
    background:linear-gradient(135deg,var(--blue),var(--orange));
    border:none;
    color:#fff;
    font-weight:600;
    width:100%;
    padding:12px;
    box-shadow:0 0 25px rgba(0,151,252,.4);
    transition:.3s;
}
.btn-main:hover{
    transform:translateY(-2px);
    box-shadow:0 0 35px rgba(255,138,0,.6);
}

/* Small text */
.text-small{
    font-size:14px;
    opacity:.7;
    text-align:center;
    margin-top:12px;
}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>


<div class="card-login">
    <h4 class="text-center mb-4">Sales Employee Login</h4>

    <?php if($error): ?>
        <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="POST" autocomplete="off">
        <div class="mb-3">
            <label>Email</label>
            <input type="email" name="email" class="form-control" required>
        </div>

        <div class="mb-3">
            <label>Password</label>
            <input type="password" name="password" class="form-control" required>
        </div>

        <button type="submit" class="btn-main">Login</button>
    </form>

    <p class="text-small">First time login? Your password will be set automatically.</p>
</div>
<script src="assets/particles.js"></script>
</body>
</html>
