<?php
session_start();
require 'config/db.php';

if(!isset($_SESSION['manager_id'])) die('Unauthorized');

$manager_id = $_SESSION['manager_id'];
$department = 'Sales';

/* ===== PAGE TITLE ===== */
$page_title = ucfirst($department) . " Manager • Attendance Correction Request";

/* ===== LAYOUT START ===== */
include 'assets/layout_top.php';
?>
<br><br>
<div class="glass-panel p-4">

<div class="glass-card mx-auto" style="max-width:600px;">
    <h4 class="mb-3 text-center">
        <i class="fa-solid fa-user-clock me-2"></i>Attendance Correction Request
    </h4>

    <form method="POST" action="save_attendance_request.php" class="row g-3">

        <div class="col-12">
            <label>Date</label>
            <input type="date" name="att_date" class="form-control" required>
        </div>

        <div class="col-12">
            <label>Reason</label>
            <textarea name="reason" class="form-control" rows="4" required></textarea>
        </div>

        <div class="col-12">
            <button class="btn-main w-100 mt-2">
                <i class="fa-solid fa-paper-plane me-1"></i> Submit Request
            </button>
        </div>

    </form>
</div>

</div>

<?php
/* ===== LAYOUT END ===== */
include 'assets/layout_bottom.php';
?>
