<?php
require 'config/db.php';

$month = $_GET['month'] ?? date('n');
$year  = $_GET['year'] ?? date('Y');

// Get employees
$emps = $pdo->query("SELECT id, full_name FROM sales_employees ORDER BY full_name")->fetchAll(PDO::FETCH_ASSOC);

// Save form submission
if(isset($_POST['save_quality'])){
    $sales_id = $_POST['sales_id'];
    $full_name = $_POST['full_name'];
    $month = $_POST['month'];
    $year = $_POST['year'];
    $new_clients = $_POST['new_clients'] ?? 0;
    $difficult_sales = $_POST['difficult_sales'] ?? 0;
    $new_sale_strategy = $_POST['new_sale_strategy'] ?? 0;

    // UPSERT with addition if exists
    $upsert = $pdo->prepare("
        INSERT INTO sale_quality_kpi
        (sales_id, full_name, month, year, new_clients, difficult_sales, new_sale_strategy)
        VALUES (?, ?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE
            new_clients = new_clients + VALUES(new_clients),
            difficult_sales = difficult_sales + VALUES(difficult_sales),
            new_sale_strategy = new_sale_strategy + VALUES(new_sale_strategy),
            updated_at = CURRENT_TIMESTAMP
    ");

    $upsert->execute([$sales_id, $full_name, $month, $year, $new_clients, $difficult_sales, $new_sale_strategy]);
    $success = "KPI saved successfully!";
}

/* ===== PAGE TITLE ===== */
$page_title = "Sales Quality KPI";

/* ===== LAYOUT START ===== */
include 'assets/layout_top.php';
?>
<br><br>
<div class="glass-panel">

<h3 class="mb-4 text-center"><i class="fa-solid fa-chart-line me-2"></i>Sales Quality KPI</h3>

<?php if(isset($success)): ?>
<div class="alert alert-success text-center"><?= htmlspecialchars($success) ?></div>
<?php endif; ?>

<form method="post" class="mb-4">

<div class="row g-3">

<div class="col-md-4">
<label>Employee:</label>
<select name="sales_id" required class="form-select" onchange="this.form.full_name.value=this.options[this.selectedIndex].text">
<option value="">Select Employee</option>
<?php foreach($emps as $e){ ?>
<option value="<?=$e['id']?>"><?=$e['full_name']?></option>
<?php } ?>
</select>
<input type="hidden" name="full_name" value="">
</div>

<div class="col-md-2">
<label>Month:</label>
<select name="month" class="form-select">
<?php for($m=1;$m<=12;$m++){ ?>
<option value="<?=$m?>" <?=$m==$month?'selected':''?>><?=$m?></option>
<?php } ?>
</select>
</div>

<div class="col-md-2">
<label>Year:</label>
<input type="number" name="year" value="<?=$year?>" class="form-control">
</div>

<div class="col-md-2">
<label>New Clients:</label>
<input type="number" name="new_clients" min="0" value="0" class="form-control">
</div>

<div class="col-md-2">
<label>Difficult Sales:</label>
<input type="number" name="difficult_sales" min="0" value="0" class="form-control">
</div>

<div class="col-md-2">
<label>New Sale Strategy:</label>
<input type="number" name="new_sale_strategy" min="0" value="0" class="form-control">
</div>

<div class="col-md-12 text-center mt-3">
<button type="submit" name="save_quality" class="btn-main px-5">
<i class="fa-solid fa-floppy-disk me-1"></i> Save KPI
</button>
</div>

</div>
</form>

</div>

<?php
/* ===== LAYOUT END ===== */
include 'assets/layout_bottom.php';
?>
