<?php
session_start();
require '../config/db.php';

$email    = trim($_POST['email']);
$password = $_POST['password'];

$stmt = $pdo->prepare("SELECT * FROM hr_manager WHERE email=? AND status=1");
$stmt->execute([$email]);
$hr = $stmt->fetch(PDO::FETCH_ASSOC);

if ($hr && password_verify($password, $hr['password'])) {

    session_regenerate_id(true);

    $_SESSION['hr_id']   = $hr['id'];
    $_SESSION['hr_name'] = $hr['full_name'];

    // login log insert
    $log = $pdo->prepare("
        INSERT INTO hr_login_logs
        (hr_id, login_date, login_time, ip_address, user_agent)
        VALUES (?, CURDATE(), CURTIME(), ?, ?)
    ");
    $log->execute([
        $hr['id'],
        $_SERVER['REMOTE_ADDR'],
        $_SERVER['HTTP_USER_AGENT']
    ]);

    header("Location: dashboard/index.php");
    exit;
}

header("Location: index.php?error=1");
