<?php
session_start();
require '../config/db.php';
if(!isset($_SESSION['hr_id'])) die('Unauthorized');

$requests = $pdo->query("
SELECT * FROM manager_attendance_requests 
ORDER BY requested_on DESC
")->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
:root{
  --blue:#0097fc;
  --orange:#ff6a00;
  --dark:#050814;
  --glass:rgba(255,255,255,.08);
}

*{font-family:Inter,Segoe UI,sans-serif}

body{
  background:var(--dark);
  color:#fff;
  overflow-x:hidden;
}

/* ===== Animated Background ===== */
.mesh{
  position:fixed; inset:0;
  background:
    radial-gradient(circle at 20% 20%, rgba(0,151,252,.35), transparent 40%),
    radial-gradient(circle at 80% 30%, rgba(255,106,0,.25), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 20s infinite alternate;
  z-index:-3;
}
@keyframes mesh{from{filter:hue-rotate(0)}to{filter:hue-rotate(25deg)}}

.grid{
  position:fixed; inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 40s linear infinite;
  z-index:-2;
}
@keyframes grid{from{transform:translateY(0)}to{transform:translateY(70px)}}

/* ===== Topbar ===== */
.topbar{
  position:fixed; top:0; left:0; right:0;
  height:64px;
  background:rgba(8,12,25,.65);
  backdrop-filter:blur(14px);
  border-bottom:1px solid rgba(255,255,255,.08);
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:0 30px;
  z-index:10;
}
.logo{
  display:flex;
  align-items:center;
  gap:10px;
  font-size:18px;
  font-weight:600;
}
.logo img{height:40px}
.logo span{color:var(--blue)}
.status{
  font-size:13px;
  display:flex;
  align-items:center;
  gap:8px;
}
.status::before{
  content:"";
  width:9px;height:9px;
  background:#1cff7a;
  border-radius:50%;
  box-shadow:0 0 12px #1cff7a;
}

/* ===== Glass Panel ===== */
.glass-box{
  background:var(--glass);
  backdrop-filter:blur(18px);
  border:1px solid rgba(255,255,255,.12);
  border-radius:16px;
  box-shadow:0 0 40px rgba(0,151,252,.25);
  padding:22px;
}

/* ===== Table ===== */
.table-wrapper{
  max-height:520px;
  overflow:auto;
  border-radius:14px;
}
.table{
  color:#fff;
}
.table th{
  background:rgba(0,0,0,.55);
  position:sticky;
  top:0;
  z-index:2;
  color:white;
  font-size:13px;
}
.table td{
  background:rgba(255,255,255,.05);
  font-size:13px;
  color:white;
}
.table tr:hover td{
  background:rgba(0,151,252,.12);
}

/* ===== Buttons ===== */
.btn-glow{
  background:linear-gradient(135deg,var(--blue),var(--orange));
  border:none;
  color:#fff;
  box-shadow:0 0 18px rgba(0,151,252,.45);
}
.btn-glow:hover{
  transform:translateY(-2px);
  box-shadow:0 0 28px rgba(255,106,0,.7);
}

.btn-approve{
  background:linear-gradient(135deg,#1cff7a,#00c851);
  border:none;
  color:#000;
}
.btn-reject{
  background:linear-gradient(135deg,#ff4d4d,#ff6a00);
  border:none;
  color:#fff;
}

input.form-control{
  background:rgba(255,255,255,.08);
  border:1px solid rgba(255,255,255,.15);
  color:#fff;
}
input.form-control::placeholder{color:#aaa}
input.form-control:focus{
  background:rgba(255,255,255,.12);
  color:#fff;
  box-shadow:0 0 0 2px rgba(0,151,252,.4);
}
.grid-bg{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.05) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.05) 1px, transparent 1px);
  background-size:60px 60px;
  z-index:1;
}

#particles{
  position:fixed;inset:0;
  z-index:2;
}
</style>
</head>

<body>

<div class="mesh"></div>
<div class="grid"></div>
<div class="mesh"></div>
<div class="grid-bg"></div>
<canvas id="particles"></canvas>
<!-- ===== Header ===== -->
<div class="topbar">
  <div class="logo">
    <img src="images/jg.webp" alt="Logo">
    Jillion <span>Gamuts</span>
  </div>
  <div class="d-flex align-items-center gap-3">
    <a href="index.php" class="btn btn-sm btn-outline-light">Dashboard</a>
    <div class="status">System Online</div>
  </div>
</div>

<div class="container-fluid" style="padding-top:90px">

<div class="glass-box">
<h4 class="mb-4">Manager Attendance Requests</h4>

<div class="table-wrapper">
<table class="table table-bordered align-middle">
<thead>
<tr>
<th>Manager ID</th>
<th>Department</th>
<th>Date</th>
<th>Requested Status</th>
<th>Reason</th>
<th>Action</th>
</tr>
</thead>
<tbody>

<?php foreach($requests as $r): ?>
<tr>
<td><?= $r['manager_id'] ?></td>
<td><?= htmlspecialchars($r['department']) ?></td>
<td><?= $r['att_date'] ?></td>
<td><?= $r['requested_status'] ?></td>
<td><?= htmlspecialchars($r['reason']) ?></td>
<td>
<?php if($r['status']=='Pending'): ?>
<form method="POST" action="hr_attendance_action.php" class="d-flex gap-2">
<input type="hidden" name="id" value="<?= $r['id'] ?>">
<input type="text" name="hr_reason" class="form-control form-control-sm" placeholder="HR Note" required>
<button name="approve" class="btn btn-approve btn-sm">Approve</button>
<button name="reject" class="btn btn-reject btn-sm">Reject</button>
</form>
<?php else: ?>
<span class="badge bg-secondary"><?= $r['status'] ?></span>
<?php endif; ?>
</td>
</tr>
<?php endforeach; ?>

</tbody>
</table>
</div>

</div>
</div>

<script>
const canvas = document.getElementById("particles");
const ctx = canvas.getContext("2d");

let w = canvas.width = window.innerWidth;
let h = canvas.height = window.innerHeight;

window.addEventListener("resize",()=>{
  w = canvas.width = window.innerWidth;
  h = canvas.height = window.innerHeight;
});

class Particle{
  constructor(){
    this.x=Math.random()*w;
    this.y=Math.random()*h;
    this.size=Math.random()*3+1;
    this.vx=(Math.random()-0.5)*1.2;
    this.vy=(Math.random()-0.5)*1.2;
    this.color=Math.random()>.5?"#0097fc":"#ff6a00";
  }
  draw(){
    ctx.beginPath();
    ctx.arc(this.x,this.y,this.size,0,Math.PI*2);
    ctx.fillStyle=this.color;
    ctx.fill();
  }
  update(){
    this.x+=this.vx;
    this.y+=this.vy;
    if(this.x<0||this.x>w) this.vx*=-1;
    if(this.y<0||this.y>h) this.vy*=-1;
  }
}

const particles=[];
for(let i=0;i<120;i++) particles.push(new Particle());

function connect(){
  for(let a=0;a<particles.length;a++){
    for(let b=a;b<particles.length;b++){
      const dx=particles[a].x-particles[b].x;
      const dy=particles[a].y-particles[b].y;
      const d=Math.sqrt(dx*dx+dy*dy);
      if(d<120){
        ctx.strokeStyle="rgba(0,151,252,.2)";
        ctx.lineWidth=1;
        ctx.beginPath();
        ctx.moveTo(particles[a].x,particles[a].y);
        ctx.lineTo(particles[b].x,particles[b].y);
        ctx.stroke();
      }
    }
  }
}

(function animate(){
  ctx.clearRect(0,0,w,h);
  particles.forEach(p=>{p.update();p.draw();});
  connect();
  requestAnimationFrame(animate);
})();
</script>

</body>
</html>
