<?php
require '../config/db.php';

// Fetch all leave requests
$leaves = $pdo->query("
    SELECT *
    FROM development_employee_leave_requests
    ORDER BY leave_date DESC
")->fetchAll(PDO::FETCH_ASSOC);

// Separate by status
$manager_approved = array_filter($leaves, fn($l) => $l['status'] === 'ManagerApproved');
$hr_approved      = array_filter($leaves, fn($l) => $l['status'] === 'HRApproved');
$rejected         = array_filter($leaves, fn($l) => $l['status'] === 'Rejected');
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="../assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
:root{
  --blue:#1f8cff;
  --orange:#ff8a00;
  --dark:#050814;
  --glass:rgba(255,255,255,.08);
}

/* RESET */
*{box-sizing:border-box;font-family:Inter,Segoe UI,Arial,sans-serif}
body{
  margin:0;
  background:var(--dark);
  color:#fff;
  min-height:100vh;
  overflow-x:hidden;
}

/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 30%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 30s ease-in-out infinite alternate;
  z-index:-5;
}
@keyframes mesh{to{filter:hue-rotate(25deg)}}

.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-4;
}
@keyframes grid{to{transform:translateY(70px)}}

/* ===== TOPBAR ===== */
.topbar{
  position:fixed;top:0;left:0;right:0;
  height:64px;
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:0 32px;
  background:rgba(8,12,25,.6);
  backdrop-filter:blur(16px);
  border-bottom:1px solid rgba(255,255,255,.08);
  z-index:10;
}
.logo{
  font-weight:600;
  letter-spacing:.3px;
}
.status{
  font-size:13px;
  display:flex;
  align-items:center;
  gap:8px;
}
.status::before{
  content:"";
  width:9px;height:9px;
  background:#1cff7a;
  border-radius:50%;
  box-shadow:0 0 12px #1cff7a;
}

/* ===== GLASS PANEL ===== */
.glass-panel{
  margin:100px 28px 40px;
  padding:28px;
  background:var(--glass);
  backdrop-filter:blur(22px);
  border:1px solid rgba(255,255,255,.15);
  border-radius:20px;
  box-shadow:0 0 60px rgba(31,140,255,.25);
}

/* ===== TABS ===== */
.nav-tabs,.nav-pills{
  border-bottom:none;
}
.nav-link{
  color:#ccc;
  background:rgba(255,255,255,.05);
  border:none;
  margin-right:6px;
  border-radius:12px;
}
.nav-link.active{
  background:linear-gradient(135deg,var(--blue),var(--orange));
  color:#fff;
  box-shadow:0 0 18px rgba(31,140,255,.6);
}

/* ===== TABLE ===== */
.table thead{
  background:rgba(0,0,0,.55);
  color:#fff;
}
.table tbody tr td{
  background:rgba(255,255,255,.05);
  color:#fff;
  vertical-align:middle;
}
.badge-status{
  font-size:.85rem;
}

/* ===== BUTTONS ===== */
.btn{
  border:none;
  box-shadow:0 0 18px rgba(31,140,255,.4);
}
.btn-success{background:linear-gradient(135deg,#22c55e,#16a34a);}
.btn-danger{background:linear-gradient(135deg,#ef4444,#b91c1c);}
.btn-secondary{background:rgba(255,255,255,.15);}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<?php include '../assets/header.php'; ?>

<div class="glass-panel">

<h3 class="mb-4 text-center">HR Leave Dashboard</h3>

<ul class="nav nav-tabs mb-3">
  <li class="nav-item">
    <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#manager">Manager Approved</button>
  </li>
  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#hr">HR Approved</button>
  </li>
  <li class="nav-item">
    <button class="nav-link text-danger" data-bs-toggle="tab" data-bs-target="#rejected">Rejected</button>
  </li>
</ul>

<div class="tab-content">

<!-- MANAGER APPROVED -->
<div class="tab-pane fade show active" id="manager">
<?php if(!$manager_approved): ?>
<div class="alert alert-info">No leaves pending HR action.</div>
<?php else: ?>
<table class="table table-striped table-hover">
<thead>
<tr><th>Emp ID</th><th>Dept</th><th>Date</th><th>Reason</th><th>Action</th></tr>
</thead>
<tbody>
<?php foreach($manager_approved as $l): ?>
<tr>
<td><?= $l['employee_id'] ?></td>
<td><?= $l['department'] ?></td>
<td><?= $l['leave_date'] ?></td>
<td><?= htmlspecialchars($l['reason']) ?></td>
<td class="d-flex gap-1">
<form method="POST" action="finalize_leave.php">
<input type="hidden" name="id" value="<?= $l['id'] ?>">
<input type="hidden" name="emp" value="<?= $l['employee_id'] ?>">
<input type="hidden" name="dept" value="<?= $l['department'] ?>">
<input type="hidden" name="date" value="<?= $l['leave_date'] ?>">
<button class="btn btn-success btn-sm">Finalize</button>
</form>

<form method="POST" action="reject_leave.php" onsubmit="return confirm('Reject this leave?')">
<input type="hidden" name="id" value="<?= $l['id'] ?>">
<button class="btn btn-danger btn-sm">Reject</button>
</form>
</td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
<?php endif; ?>
</div>

<!-- HR APPROVED -->
<div class="tab-pane fade" id="hr">
<?php if(!$hr_approved): ?>
<div class="alert alert-info">No HR approved leaves.</div>
<?php else: ?>
<table class="table table-striped table-hover">
<thead><tr><th>Emp ID</th><th>Dept</th><th>Date</th><th>Status</th></tr></thead>
<tbody>
<?php foreach($hr_approved as $l): ?>
<tr>
<td><?= $l['employee_id'] ?></td>
<td><?= $l['department'] ?></td>
<td><?= $l['leave_date'] ?></td>
<td><span class="badge bg-success">HRApproved</span></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
<?php endif; ?>
</div>

<!-- REJECTED -->
<div class="tab-pane fade" id="rejected">
<?php if(!$rejected): ?>
<div class="alert alert-info">No rejected leaves.</div>
<?php else: ?>
<table class="table table-striped table-hover">
<thead><tr><th>Emp ID</th><th>Dept</th><th>Date</th><th>Status</th></tr></thead>
<tbody>
<?php foreach($rejected as $l): ?>
<tr>
<td><?= $l['employee_id'] ?></td>
<td><?= $l['department'] ?></td>
<td><?= $l['leave_date'] ?></td>
<td><span class="badge bg-danger">Rejected</span></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
<?php endif; ?>
</div>

</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="../assets/particles.js"></script>
</body>
</html>
