<?php
require '../config/auth.php';
require '../config/db.php';

$success = '';
$error = '';

if ($_POST) {

    $department = $_POST['department'];
    
    // Map department to table
    $table_map = [
        'Sales' => 'sales_employees',
        'Design' => 'design_employees',
        'Development' => 'development_employees',
        'Marketing' => 'marketing_employees'
    ];

    if (!isset($table_map[$department])) {
        $error = "Invalid department";
    } else {
        $table = $table_map[$department];

        $stmt = $pdo->prepare("INSERT INTO $table
            (full_name, email, phone, cnic, gender, dob, address, designation, joining_date, employment_type, basic_salary)
            VALUES (?,?,?,?,?,?,?,?,?,?,?)");

        $stmt->execute([
            $_POST['full_name'],
            $_POST['email'],
            $_POST['phone'],
            $_POST['cnic'],
            $_POST['gender'],
            $_POST['dob'],
            $_POST['address'],
            $_POST['designation'],
            $_POST['joining_date'],
            $_POST['employment_type'],
            $_POST['basic_salary']
        ]);

        $success = "Employee created successfully. They will set password on first login.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="../assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
:root{
  --blue:#0097fc;
  --orange:#ff6a00;
  --dark:#050814;
  --glass:rgba(255,255,255,.08);
}

*{margin:0;padding:0;box-sizing:border-box;font-family:Inter,Segoe UI,Arial,sans-serif}

body{
  background:var(--dark);
  color:#fff;
  min-height:100vh;
  overflow-x:hidden;
}

/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

/* Grid */
.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}
@keyframes grid{to{transform:translateY(70px)}}

/* ===== Topbar ===== */
.topbar{
  position:fixed;
  top:0;left:0;right:0;
  height:64px;
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:0 36px;
  background:rgba(8,12,25,.6);
  backdrop-filter:blur(14px);
  border-bottom:1px solid rgba(255,255,255,.06);
  z-index:10;
}
.logo{
  display:flex;
  align-items:center;
  gap:10px;
  font-weight:600;
}
.logo img{height:42px}
.status{
  font-size:13px;
  display:flex;
  align-items:center;
  gap:8px;
}
.status::before{
  content:"";
  width:9px;height:9px;
  background:#1cff7a;
  border-radius:50%;
  box-shadow:0 0 12px #1cff7a;
}

/* ===== Glass Form Panel ===== */
.glass-panel{
  max-width:900px;
  margin:110px auto 40px;
  padding:28px;
  background:var(--glass);
  backdrop-filter:blur(22px);
  border:1px solid rgba(255,255,255,.14);
  border-radius:18px;
  box-shadow:0 0 50px rgba(31,140,255,.3);
}

/* Inputs */
.form-control, .form-select{
  background:rgba(0,0,0,.35);
  border:1px solid rgba(255,255,255,.15);
  color:#fff;
}
.form-control:focus, .form-select:focus{
  border-color:var(--blue);
  box-shadow:0 0 0 1px var(--blue),0 0 18px rgba(0,151,252,.45);
  background:rgba(0,0,0,.4);
  color:#fff;
}
label{font-size:13px;opacity:.8}

/* Button */
.btn-main{
  background:linear-gradient(135deg,var(--blue),var(--orange));
  border:none;
  color:#fff;
  padding:14px;
  font-weight:600;
  box-shadow:0 0 25px rgba(0,151,252,.4);
}
.btn-main:hover{
  transform:translateY(-2px);
  box-shadow:0 0 35px rgba(255,138,0,.6);
}
</style>
</head>

<body>
<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<!-- ===== SAME MASTER HEADER ===== -->
<?php include '../assets/header.php'; ?>

<!-- ===== TOP BAR ===== -->

<!-- ===== FORM ===== -->
<div class="glass-panel">

<h4 class="mb-4">Create Employee</h4>

<?php if($success): ?>
  <div class="alert alert-success"><?= $success ?></div>
<?php endif; ?>

<?php if($error): ?>
  <div class="alert alert-danger"><?= $error ?></div>
<?php endif; ?>

<form method="POST">

<div class="row">
  <div class="col-md-6 mb-3">
    <label>Full Name</label>
    <input type="text" name="full_name" class="form-control" required>
  </div>
  <div class="col-md-6 mb-3">
    <label>Email</label>
    <input type="email" name="email" class="form-control" required>
  </div>
</div>

<div class="row">
  <div class="col-md-6 mb-3">
    <label>Phone</label>
    <input type="text" name="phone" class="form-control">
  </div>
  <div class="col-md-6 mb-3">
    <label>CNIC</label>
    <input type="text" name="cnic" class="form-control">
  </div>
</div>

<div class="row">
  <div class="col-md-4 mb-3">
    <label>Gender</label>
    <select name="gender" class="form-select">
      <option value="">Select</option>
      <option>Male</option>
      <option>Female</option>
      <option>Other</option>
    </select>
  </div>
  <div class="col-md-4 mb-3">
    <label>Date of Birth</label>
    <input type="date" name="dob" class="form-control">
  </div>
  <div class="col-md-4 mb-3">
    <label>Designation</label>
    <input type="text" name="designation" class="form-control">
  </div>
</div>

<div class="mb-3">
  <label>Address</label>
  <textarea name="address" class="form-control"></textarea>
</div>

<div class="row">
  <div class="col-md-4 mb-3">
    <label>Department</label>
    <select name="department" class="form-select" required>
      <option value="">Select</option>
      <option>Sales</option>
      <option>Design</option>
      <option>Development</option>
      <option>Marketing</option>
    </select>
  </div>
  <div class="col-md-4 mb-3">
    <label>Joining Date</label>
    <input type="date" name="joining_date" class="form-control" required>
  </div>
  <div class="col-md-4 mb-3">
    <label>Employment Type</label>
    <select name="employment_type" class="form-select">
      <option value="">Select</option>
      <option>Permanent</option>
      <option>Contract</option>
      <option>Intern</option>
    </select>
  </div>
</div>

<div class="mb-4">
  <label>Basic Salary</label>
  <input type="number" name="basic_salary" step="0.01" class="form-control">
</div>

<button class="btn btn-main w-100">Create Employee</button>

</form>
</div>
<script src="../assets/particles.js"></script>
</body>
</html>
