<?php
session_start();
require '../config/db.php';

if (!isset($_SESSION['set_pass_id'])) die('Access denied');

$error = '';

if ($_POST) {
    if ($_POST['password'] !== $_POST['confirm_password']) {
        $error = "Passwords do not match";
    } elseif (strlen($_POST['password']) < 6) {
        $error = "Password must be at least 6 characters";
    } else {
        $hash = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $pdo->prepare("
            UPDATE design_employees
            SET password=?, must_change_password=0
            WHERE id=?
        ")->execute([$hash, $_SESSION['set_pass_id']]);

        unset($_SESSION['set_pass_id']);
        header("Location: login.php");
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body {
    background: linear-gradient(135deg,#232526,#414345);
    min-height: 100vh;
    display: flex;
    align-items: center;
    justify-content: center;
    font-family: Arial, sans-serif;
}
.card-pass {
    max-width: 400px;
    width: 100%;
    padding: 30px;
    border-radius: 8px;
}
</style>
</head>
<body>

<div class="card shadow card-pass">
    <div class="card-body">
        <h4 class="text-center mb-4 text-dark">Set Your Password</h4>

        <?php if($error): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>

        <form method="POST" autocomplete="off">

            <div class="mb-3">
                <label for="password" class="form-label text-dark">New Password</label>
                <input type="password" id="password" name="password" class="form-control" required>
            </div>

            <div class="mb-3">
                <label for="confirm_password" class="form-label text-dark">Confirm Password</label>
                <input type="password" id="confirm_password" name="confirm_password" class="form-control" required>
            </div>

            <button type="submit" class="btn btn-dark w-100">Save Password</button>
        </form>

        <p class="mt-3 text-center text-dark" style="font-size: 14px;">
            Your password must be at least 6 characters.
        </p>
    </div>
</div>

<
