<?php
session_start();
require 'config/db.php';

if(!isset($_SESSION['employee_id'])) die('Unauthorized');

$designer_id = $_SESSION['employee_id'];

/* ===============================
   RE-UPLOAD DESIGN
================================ */
if(isset($_POST['upload_design'])){
    $project_id = $_POST['project_id'];

    foreach($_FILES['design_files']['name'] as $i => $name){
        if($_FILES['design_files']['error'][$i] === 0){

            $ext  = pathinfo($name, PATHINFO_EXTENSION);
            $file = 'design_'.$project_id.'_'.time().'_'.$i.'.'.$ext;
            $tmp  = $_FILES['design_files']['tmp_name'][$i];

            move_uploaded_file($tmp, "../uploads/designs/".$file);

            $pdo->prepare("
                INSERT INTO project_files
                (project_id, uploaded_by, file_stage, file_path)
                VALUES (?,?,?,?)
            ")->execute([
                $project_id,
                'Designer',
                'Design',
                $file
            ]);
        }
    }

    $pdo->prepare("
        UPDATE projects
        SET status='DesignUploaded'
        WHERE id=? AND designer_id=?
    ")->execute([$project_id,$designer_id]);

    $pdo->prepare("
        INSERT INTO project_actions
        (project_id, action_by, action)
        VALUES (?,?,?)
    ")->execute([
        $project_id,
        'Designer',
        'Revised design uploaded'
    ]);

    header("Location: revision_requests.php?success=1");
    exit;
}

/* ===============================
   FETCH REVISION PROJECTS
================================ */
$stmt = $pdo->prepare("
    SELECT * FROM projects
    WHERE designer_id=? AND status='RevisionRequested'
    ORDER BY created_at DESC
");
$stmt->execute([$designer_id]);
$projects = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* ===== PAGE TITLE ===== */
$page_title = "Designer • Revision Requests";

/* ===== LAYOUT START ===== */
include 'assets/layout_top.php';
?>

<br><br><br>

<h3 class="text-center mb-4">
  <i class="fa-solid fa-rotate-left me-2"></i>
  Revision Requested Projects
</h3>

<?php if(isset($_GET['success'])): ?>
<div class="glass-card text-center">
  <i class="fa-solid fa-check-circle fa-2x mb-2 text-success"></i>
  <p class="mb-0">Design re-uploaded successfully</p>
</div>
<?php endif; ?>

<?php if(!$projects): ?>
<div class="glass-card text-center">
  <i class="fa-solid fa-circle-info fa-2x mb-2"></i>
  <p class="mb-0">No revision requests</p>
</div>
<?php endif; ?>

<?php foreach($projects as $p): ?>
<div class="glass-card">

  <h5 class="mb-3">
    <i class="fa-solid fa-triangle-exclamation me-2 text-warning"></i>
    <?= htmlspecialchars($p['title']) ?>
    <span class="badge bg-warning text-dark ms-2">Revision</span>
  </h5>

  <div class="row mb-3">
    <div class="col-md-6">
      <p><b>Client:</b> <?= htmlspecialchars($p['client_name']) ?></p>
      <p><b>Sales:</b> <?= htmlspecialchars($p['sales_name']) ?></p>
    </div>
    <div class="col-md-6">
      <b>Description:</b><br>
      <?= nl2br(htmlspecialchars($p['description'])) ?>
    </div>
  </div>

  <hr>

  <!-- FILE HISTORY -->
  <h6>
    <i class="fa-solid fa-paperclip me-1"></i>
    All Project Files
  </h6>

  <?php
  $files = $pdo->prepare("
      SELECT * FROM project_files
      WHERE project_id=?
      ORDER BY uploaded_at DESC
  ");
  $files->execute([$p['id']]);
  foreach($files as $f):
  ?>
    <div class="file-box mb-1">
      <a href="../uploads/designs/<?= htmlspecialchars($f['file_path']) ?>" target="_blank">
        <i class="fa-solid fa-file-lines me-1"></i>
        <?= htmlspecialchars($f['file_path']) ?>
      </a>
      <span class="text-white">
        (<?= $f['uploaded_by'] ?> – <?= $f['file_stage'] ?>)
      </span>
    </div>
  <?php endforeach; ?>

  <hr>

  <!-- SALES COMMENT -->
  <h6>
    <i class="fa-solid fa-comment-dots me-1"></i>
    Sales Comment
  </h6>
  <div class="alert text-white">
    <?= nl2br(htmlspecialchars($p['comments'] ?? 'No comment provided')) ?>
  </div>

  <hr>

  <!-- RE-UPLOAD -->
  <h6>
    <i class="fa-solid fa-cloud-arrow-up me-1"></i>
    Re-upload Revised Design
  </h6>

  <form method="POST" enctype="multipart/form-data">
    <input type="hidden" name="project_id" value="<?= $p['id'] ?>">
    <input type="file" name="design_files[]" multiple required class="form-control mb-3">
    <button name="upload_design" class="btn-main">
      Submit Revised Design
    </button>
  </form>

</div>
<?php endforeach; ?>

<?php
/* ===== LAYOUT END ===== */
include 'assets/layout_bottom.php';
?>
