<?php
session_start();

if (!isset($_SESSION['manager_id'])) die('Unauthorized');
if ($_SESSION['department'] !== 'Design') {
    header('Location: login.php');
    exit;
}

require 'config/db.php';

$dept  = 'Design';
$table = strtolower($dept).'_employee_entry_times';

$msg = '';
$type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $employee_id = (int)$_POST['employee_id'];
    $entry_date  = $_POST['entry_date'];
    $entry_time  = $_POST['entry_time'];

    // 🔍 Duplicate check (employee + date)
    $check = $pdo->prepare("
        SELECT id FROM $table
        WHERE employee_id=? AND entry_date=?
    ");
    $check->execute([$employee_id, $entry_date]);

    if ($check->rowCount() > 0) {
        $msg  = "Entry time already set for this employee on selected date.";
        $type = "danger";
    } else {
        $pdo->prepare("
            INSERT INTO $table
            (department, employee_id, entry_date, entry_time, created_by_manager)
            VALUES (?,?,?,?,?)
        ")->execute([
            $dept,
            $employee_id,
            $entry_date,
            $entry_time,
            $_SESSION['manager_id']
        ]);

        $msg  = "Entry time set successfully for selected date.";
        $type = "success";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Set Employee Entry Time</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{ background:#f1f5f9; font-family:Arial,sans-serif; }
.glass-container{
    max-width:600px;
    margin:50px auto;
    padding:25px;
}
.glass-card{
    background:var(--glass);
    backdrop-filter:blur(22px);
    border-radius:16px;
    padding:25px;
    box-shadow:0 10px 25px rgba(0,0,0,.08);
    border:1px solid rgba(255,255,255,.35);
}
.glass-card .card-header{
    background: rgba(0,0,0,.8);
    color:#fff;
    font-weight:600;
    border-radius:12px 12px 0 0;
    font-size:1.1rem;
}
button{ border-radius:10px; }
</style>
</head>
<body>

<?php include 'assets/layout_top.php'; ?>

<div class="glass-container">

<div class="glass-card card shadow">

<div class="card-header">
Set Employee Entry Time (Date-Wise)
</div>

<div class="card-body">

<?php if($msg): ?>
<div class="alert alert-<?= $type ?>"><?= htmlspecialchars($msg) ?></div>
<?php endif; ?>

<form method="POST" id="entryForm">

<div class="mb-3">
<label class="form-label">Employee</label>
<select name="employee_id" class="form-select" required>
<option value="">-- Select Employee --</option>
<?php
$emps = $pdo->query("SELECT id, full_name FROM design_employees ORDER BY full_name");
foreach($emps as $e){
    echo "<option value='{$e['id']}'>{$e['full_name']}</option>";
}
?>
</select>
</div>

<div class="mb-3">
<label class="form-label">Entry Date</label>
<input type="date" name="entry_date" class="form-control" required>
</div>

<div class="mb-3">
<label class="form-label">Entry Time</label>
<input type="time" name="entry_time" class="form-control" required>
</div>

<button class="btn btn-primary w-100">Set Entry Time</button>

</form>

</div>
</div>

</div>

<?php include 'assets/layout_bottom.php'; ?>

<script>
// prevent Enter auto-submit
document.getElementById('entryForm').addEventListener('keydown', e=>{
    if(e.key === 'Enter') e.preventDefault();
});
</script>

</body>
</html>
