<?php
session_start();
require 'config/db.php';

if (!isset($_SESSION['manager_id'])) {
    die('Unauthorized');
}

/* ===============================
   ASSIGN DESIGNER
================================ */
if(isset($_POST['assign'])){
    $project_id  = $_POST['project_id'];
    $designer_id = $_POST['designer_id'];

    $designer = $pdo->prepare("SELECT full_name FROM design_employees WHERE id=?");
    $designer->execute([$designer_id]);
    $designer_name = $designer->fetchColumn();

    if($designer_name){
        $pdo->prepare("
            UPDATE projects
            SET designer_id=?, designer_name=?, status='AssignedToDesigner'
            WHERE id=?
        ")->execute([$designer_id,$designer_name,$project_id]);

        $pdo->prepare("
            INSERT INTO project_actions
            (project_id, action_by, action)
            VALUES (?,?,?)
        ")->execute([
            $project_id,
            'Design Manager',
            "Project assigned to designer: $designer_name"
        ]);
    }
}

/* ===============================
   FETCH PROJECTS
================================ */
$projects = $pdo->query("
    SELECT * FROM projects
    WHERE status='SentToDesigner'
    ORDER BY created_at DESC
")->fetchAll(PDO::FETCH_ASSOC);

/* ===============================
   DESIGNERS
================================ */
$designers = $pdo->query("
    SELECT id, full_name
    FROM design_employees
    WHERE status = 1
    ORDER BY full_name ASC
")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Design Manager Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{ background:#f1f5f9; font-family:Arial,sans-serif; }
.glass-container{
    max-width:1200px;
    margin:40px auto;
    padding:25px;
}
.glass-card{
    background: rgba(255,255,255,.65);
    backdrop-filter: blur(14px);
    -webkit-backdrop-filter: blur(14px);
    border-radius:16px;
    padding:20px;
    box-shadow:0 10px 25px rgba(0,0,0,.08);
    border:1px solid rgba(255,255,255,.35);
    margin-bottom:25px;
}
.glass-card .card-header{
    background: rgba(37,99,235,.85);
    color:#fff;
    font-weight:600;
    border-radius:12px 12px 0 0;
}
select, button{ border-radius:10px; }
button{ background:#2563eb; color:#fff; border:none; font-weight:600; padding:6px 14px; }
button:hover{ background:#1d4ed8; }
</style>
</head>
<body>

<?php include 'assets/layout_top.php'; ?>

<div class="glass-container">

<h3 class="mb-4 text-center">🖌 Projects Sent To Designer</h3>

<?php if(!$projects): ?>
<div class="alert alert-info">No projects available</div>
<?php endif; ?>

<?php foreach($projects as $p): ?>
<div class="glass-card">
<div class="card-header">
<?= htmlspecialchars($p['title']) ?>
</div>

<div class="card-body">
<div class="row">
<div class="col-md-6 mb-2">
<b>Client:</b> <?= htmlspecialchars($p['client_name']) ?><br>
<b>Price:</b> <?= $p['price'] ?><br>
<b>Sales:</b> <?= htmlspecialchars($p['sales_name']) ?>
</div>

<div class="col-md-6 mb-2">
<b>Description:</b><br>
<?= nl2br(htmlspecialchars($p['description'])) ?>
</div>
</div>

<hr>

<form method="POST" class="row g-2 align-items-end">
<input type="hidden" name="project_id" value="<?= $p['id'] ?>">

<div class="col-md-8">
<label>Select Designer</label>
<select name="designer_id" class="form-select" required>
<option value="">-- Select Designer --</option>
<?php foreach($designers as $d): ?>
<option value="<?= $d['id'] ?>"><?= htmlspecialchars($d['full_name']) ?></option>
<?php endforeach; ?>
</select>
</div>

<div class="col-md-4">
<button name="assign" class="btn w-100">Assign Designer</button>
</div>
</form>

</div>
</div>
<?php endforeach; ?>

</div>

<?php include 'assets/layout_bottom.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
