<?php
session_start();
require 'config/db.php';

if(!isset($_SESSION['manager_id'])) die('Unauthorized');

$manager_id = $_SESSION['manager_id'];
$dept = $_SESSION['department'];
$dept = strtolower($_SESSION['department']);
$dept = preg_replace('/[^a-z0-9_]/','',$dept);

$leaveTable = $dept.'_manager_leaves';
$msgTable   = $dept.'_manager_leave_messages';

// Fetch leaves by status
$statuses = ['Pending', 'Approved', 'Rejected'];
$leavesData = [];

foreach($statuses as $status){
    $stmt = $pdo->prepare("
        SELECT * FROM $leaveTable
        WHERE manager_id=? AND status=?
        ORDER BY requested_on DESC
    ");
    $stmt->execute([$manager_id, $status]);
    $leavesData[$status] = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>My Leave Requests</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background:#f1f5f9; font-family:Arial,sans-serif; }
.glass-container{
    max-width:1200px;
    margin:40px auto;
    padding:25px;
    background:var(--glass);
    backdrop-filter:blur(22px);
}
.glass-card{
    background:var(--glass);
   
    -webkit-backdrop-filter: blur(24px);
    border-radius:16px;
    padding:20px;
    box-shadow:0 10px 25px rgba(0,0,0,.08);
    border:1px solid rgba(255,255,255,.35);
}
.chat-box{
    background:var(--glass);
    backdrop-filter:blur(22px);
    padding:10px;
    border-radius:10px;
    font-size:14px;
    max-height:150px;
    overflow-y:auto;
    margin-bottom:10px;
}
.tab-content{
    background:var(--glass);
    backdrop-filter:blur(22px);
}
.chat-hr{ color:#0d6efd; font-weight:500; }
.chat-manager{ color:#198754; font-weight:500; }
select, button{ border-radius:10px; }
button{ background:#2563eb; color:#fff; border:none; font-weight:600; padding:6px 14px; }
button:hover{ background:#1d4ed8; }
.badge-status{ font-weight:600; }
</style>
</head>
<body>

<?php include 'assets/layout_top.php'; ?>

<div class="glass-container glass-card">

<h4 class="mb-4 text-center">📝 My Leave Requests</h4>

<!-- TABS -->
<ul class="nav nav-tabs mb-3" role="tablist">
    <?php foreach($statuses as $i => $status): ?>
    <li class="nav-item">
        <button class="nav-link <?= $i==0?'active':'' ?>" data-bs-toggle="tab" data-bs-target="#<?= strtolower($status) ?>">
            <?= $status ?>
            <?php if(count($leavesData[$status])): ?>
                <span class="badge bg-danger"><?= count($leavesData[$status]) ?></span>
            <?php endif; ?>
        </button>
    </li>
    <?php endforeach; ?>
</ul>

<div class="tab-content">
<?php foreach($statuses as $i => $status): ?>
<div class="tab-pane fade <?= $i==0?'show active':'' ?>" id="<?= strtolower($status) ?>">
    <?php if(!$leavesData[$status]): ?>
        <div class="alert alert-info">No <?= strtolower($status) ?> leave requests.</div>
    <?php else: ?>
        <?php foreach($leavesData[$status] as $l): ?>
        <div class="card mb-3 shadow-sm glass-card">
        <div class="card-body">

            <p><b>Date:</b> <?= $l['leave_date'] ?></p>
            <p><b>Reason:</b> <?= htmlspecialchars($l['reason']) ?></p>
            <p>
                <b>Status:</b>
                <span class="badge badge-status <?= $status=='Approved'?'bg-success':($status=='Rejected'?'bg-danger':'bg-warning text-dark') ?>">
                    <?= $status ?>
                </span>
            </p>

            <!-- CHAT -->
            <div class="chat-box">
            <?php
            $msgs = $pdo->prepare("
                SELECT * FROM $msgTable
                WHERE leave_id=?
                ORDER BY created_at ASC
            ");
            $msgs->execute([$l['id']]);
            if($msgs->rowCount()==0){
                echo "<span class='text-muted'>No messages yet</span>";
            }else{
                foreach($msgs as $m){
                    $cls = ($m['sender']=='HR') ? 'chat-hr' : 'chat-manager';
                    echo "<div class='$cls'><b>{$m['sender']}:</b> ".htmlspecialchars($m['message'])."</div>";
                }
            }
            ?>
            </div>

            <!-- REPLY FORM (ONLY PENDING) -->
            <?php if($status=='Pending'): ?>
            <form method="POST" action="manager_reply_hr.php" class="d-flex gap-2">
                <input type="hidden" name="leave_id" value="<?= $l['id'] ?>">
                <input type="text" name="message" maxlength="25" class="form-control form-control-sm"
                       placeholder="Reply to HR (25 chars)" required>
                <button class="btn btn-sm btn-primary">Send</button>
            </form>
            <?php else: ?>
            <div class="text-muted mt-2">Messaging closed (Leave <?= $status ?>)</div>
            <?php endif; ?>

        </div>
        </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>
<?php endforeach; ?>
</div>

</div>

<?php include 'assets/layout_bottom.php'; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
