<?php
session_start();
require 'config/db.php';

if(!isset($_SESSION['manager_id'])) die('Unauthorized');

$manager_id = $_SESSION['manager_id'];
$department = 'Design';
?>
<!DOCTYPE html>
<html>
<head>
<title>Attendance Correction Request</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{
    background:#f1f5f9;
    font-family:Arial, sans-serif;
}

/* Glass container */
.glass-container{
    padding:30px;
    max-width:600px;
    margin:50px auto;
}

/* Glass card */
.glass-card{
   
    -webkit-backdrop-filter: blur(14px);
    border-radius:16px;
    padding:25px;
    background:var(--glass);
    backdrop-filter:blur(22px);
    box-shadow:0 10px 25px rgba(0,0,0,.08);
    border:1px solid rgba(255,255,255,.35);
}

/* Card header */
.glass-card .card-header{
    background:var(--glass);
    backdrop-filter:blur(22px);
    color:#fff;
    font-weight:600;
    font-size:18px;
    border-radius:10px 10px 0 0;
    
}

/* Form inputs */
input, textarea, select, button{
    border-radius:10px;
    background:var(--glass);
    backdrop-filter:blur(22px);
}

button{
    background:#2563eb;
    color:#fff;
    border:none;
    font-weight:600;
    padding:10px 18px;
    cursor:pointer;
}

button:hover{
    background:#1d4ed8;
}

label{
    font-weight:600;
    margin-top:8px;
}
</style>
</head>
<body>

<?php include 'assets/layout_top.php'; ?>

<div class="glass-container">
<div class="glass-card">
<div class="card-header">📝 Attendance Correction Request</div>
<div class="card-body">

<form method="POST" action="save_attendance_request.php">
    <div class="mb-3">
        <label>Date</label>
        <input type="date" name="att_date" class="form-control" required>
    </div>

    <div class="mb-3">
        <label>Reason</label>
        <textarea name="reason" class="form-control" rows="4" required></textarea>
    </div>

    <button class="btn btn-primary w-100">Submit Request</button>
</form>

</div>
</div>
</div>

<?php include 'assets/layout_bottom.php'; ?>

</body>
</html>
