<?php
session_start();
require 'config/db.php';
if(!isset($_SESSION['manager_id'])) die('Unauthorized');

$dept = strtolower($_SESSION['department']);
$table = $dept.'_manager_leaves';
?>
<!DOCTYPE html>
<html>
<head>
<title>Apply Leave</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{
    background:#f1f5f9;
    font-family:Arial, sans-serif;
}

/* Glass container */
.glass-container{
    padding:30px;
    max-width:600px;
    margin:50px auto;
}

/* Glass card */
.glass-card{
    width:100%;
    max-width:400px;
    padding:30px;
    border-radius:18px;
    background:var(--glass);
    backdrop-filter:blur(22px);
    border:1px solid rgba(255,255,255,.14);
    box-shadow:0 12px 35px rgba(0,151,252,.25);
}

/* Card header */
.glass-card .card-header{
    width:100%;
    max-width:400px;
    padding:30px;
    border-radius:18px;
    background:var(--glass);
    backdrop-filter:blur(22px);
    border:1px solid rgba(255,255,255,.14);
    box-shadow:0 12px 35px rgba(0,151,252,.25);
}

/* Form inputs */
input, textarea, select, button{
    border-radius:10px;
}

button{
    background:#2563eb;
    color:#fff;
    border:none;
    font-weight:600;
    padding:10px 18px;
    cursor:pointer;
}

button:hover{
    background:#1d4ed8;
}

label{
    font-weight:600;
    margin-top:8px;
}
</style>
</head>
<body>
<?php include 'assets/layout_top.php'; ?>
<div class="glass-container">
<div class="glass-card">
<div class="card-header">📄 Manager Leave Request</div>
<div class="card-body">

<form method="POST" action="save_manager_leave.php">
    <div class="mb-3">
        <label>Leave Date</label>
        <input type="date" name="leave_date" class="form-control" required>
    </div>

    <div class="mb-3">
        <label>Reason</label>
        <textarea name="reason" class="form-control" required rows="4"></textarea>
    </div>

    <button class="btn btn-primary w-100">Submit Leave</button>
</form>

</div>
</div>
</div>

</body>
</html>
<?php include 'assets/layout_bottom.php'; ?>