<?php
session_start();
require 'config/db.php';
if (!isset($_SESSION['admin_id'])) {
    header("Location: login.php");
    exit;
}
$success = '';

if ($_POST) {
    $stmt = $pdo->prepare("
        INSERT INTO managers
        (full_name, email, phone, department, created_by_hr)
        VALUES (?,?,?,?,?)
    ");
    $stmt->execute([
        $_POST['name'],
        $_POST['email'],
        $_POST['phone'],
        $_POST['department'],
        $_SESSION['hr_id']
    ]);
    $success = true;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="../assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
:root{

  --glass:rgba(255,255,255,.08);
}

*{margin:0;padding:0;box-sizing:border-box;font-family:Inter,Segoe UI,Arial,sans-serif}
body{background:var(--dark);color:#fff;min-height:100vh;overflow-x:hidden}

/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

/* Grid */
.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}
@keyframes grid{to{transform:translateY(70px)}}

/* ===== Topbar ===== */
.topbar{
  position:fixed;
  top:0;left:0;right:0;
  height:64px;
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:0 36px;
  background:rgba(8,12,25,.6);
  backdrop-filter:blur(14px);
  border-bottom:1px solid rgba(255,255,255,.06);
  z-index:10;
}
.logo{display:flex;align-items:center;font-weight:600;font-size:1.2rem;}
.status{font-size:13px;display:flex;align-items:center;gap:8px;}
.status::before{
  content:"";
  width:9px;height:9px;
  background:#1cff7a;
  border-radius:50%;
  box-shadow:0 0 12px #1cff7a;
}

/* ===== Glass Form Panel ===== */
.glass-panel{
  max-width:600px;
  margin:110px auto 40px;
  padding:28px;
  background:var(--glass);
  backdrop-filter:blur(22px);
  border:1px solid rgba(255,255,255,.14);
  border-radius:18px;
  box-shadow:0 0 50px rgba(31,140,255,.3);
}

/* Inputs */
.form-control,.form-select{
  background:rgba(0,0,0,.35);
  border:1px solid rgba(255,255,255,.15);
  color:#fff;
}
.form-control:focus,.form-select:focus{
  border-color:var(--blue);
  box-shadow:0 0 0 1px var(--blue),0 0 18px rgba(0,151,252,.45);
  background:rgba(0,0,0,.4);
  color:#fff;
}
label{font-size:13px;opacity:.8}

/* Button */
.btn-main{
  background:linear-gradient(135deg,var(--blue),var(--orange));
  border:none;
  color:#fff;
  padding:12px;
  font-weight:600;
  width:100%;
  box-shadow:0 0 25px rgba(0,151,252,.4);
  transition:.3s;
}
.btn-main:hover{
  transform:translateY(-2px);
  box-shadow:0 0 35px rgba(255,138,0,.6);
}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<!-- ===== SAME MASTER HEADER ===== -->
<?php include '../assets/header.php'; ?>

<div class="glass-panel">
<h4 class="mb-4">Create Manager</h4>

<?php if(isset($success)): ?>
<div class="alert alert-success">
 Manager created. Password will be set on first login.
</div>
<?php endif; ?>

<form method="POST">

<div class="mb-3">
<label>Full Name</label>
<input name="name" class="form-control" placeholder="Full Name" required>
</div>

<div class="mb-3">
<label>Email</label>
<input name="email" type="email" class="form-control" placeholder="Email" required>
</div>

<div class="mb-3">
<label>Phone</label>
<input name="phone" class="form-control" placeholder="Phone">
</div>

<div class="mb-3">
<label>Department</label>
<select name="department" class="form-select" required>
  <option value="">Select Department</option>
  <option>Sales</option>
  <option>Design</option>
  <option>Development</option>
  <option>Marketing</option>
</select>
</div>

<button class="btn-main">Create Manager</button>
</form>
</div>
<script src="../assets/particles.js"></script>
</body>
</html>
