<?php
session_start();
require 'config/db.php';

if(!isset($_SESSION['admin_id'])) die('Unauthorized');

/* ===============================
   FETCH COMPLETED PROJECTS
================================ */
$stmt = $pdo->query("
    SELECT *
    FROM projects
    WHERE status='Completed'
    ORDER BY created_at DESC
");
$projects = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>JG - Completed Projects</title>
<link rel="icon" type="image/png" href="images/jg.webp">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
:root{
  --glass:rgba(255,255,255,.08);
}

*{margin:0;padding:0;box-sizing:border-box;font-family:Inter,Segoe UI,Arial,sans-serif}
body{background:var(--dark);color:#fff;min-height:100vh;overflow-x:hidden}

/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

/* Grid */
.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}
@keyframes grid{to{transform:translateY(70px)}}

/* ===== Topbar ===== */
.topbar{
  position:fixed;
  top:0;left:0;right:0;
  height:64px;
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:0 36px;
  background:rgba(8,12,25,.6);
  backdrop-filter:blur(14px);
  border-bottom:1px solid rgba(255,255,255,.06);
  z-index:10;
}
.logo{display:flex;align-items:center;font-weight:600;font-size:1.2rem;}
.status{font-size:13px;display:flex;align-items:center;gap:8px;}
.status::before{
  content:"";
  width:9px;height:9px;
  background:#1cff7a;
  border-radius:50%;
  box-shadow:0 0 12px #1cff7a;
}

/* ===== Glass Panel ===== */
.glass-panel{
  max-width:1100px;
  margin:110px auto 40px;
  padding:28px;
  background:var(--glass);
  backdrop-filter:blur(22px);
  border:1px solid rgba(255,255,255,.14);
  border-radius:18px;
  box-shadow:0 0 50px rgba(31,140,255,.3);
}

/* Cards & Files */
.card{border-radius:0;background:rgba(0,0,0,.35);border:1px solid rgba(255,255,255,.15);color:#fff}
.card-header{background:rgba(8,12,25,.8);border-bottom:1px solid rgba(255,255,255,.1)}
.file-box{
    background:rgba(255,255,255,.05);
    padding:6px 10px;
    margin-bottom:4px;
    border-left:4px solid #1cff7a;
    font-size:14px;
    border-radius:4px;
}
.section-title{
    font-weight:600;
    margin-top:20px;
}
.action-box{
    background:rgba(255,255,255,.05);
    border-left:4px solid #1cff7a;
    padding:6px 10px;
    margin-bottom:5px;
    font-size:13px;
    border-radius:4px;
}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<!-- ===== SAME MASTER HEADER ===== -->
<?php include 'assets/header.php'; ?>

<div class="glass-panel">
<h3 class="mb-4">Completed Projects – Full Audit View</h3>

<?php if(!$projects): ?>
<div class="alert alert-info">
No completed projects found
</div>
<?php endif; ?>

<?php
if (!function_exists('showFiles')) {
    function showFiles($pdo, $project_id, $stage, $path) {
        $stmt = $pdo->prepare("
            SELECT * FROM project_files
            WHERE project_id=? AND file_stage=?
            ORDER BY uploaded_at ASC
        ");
        $stmt->execute([$project_id, $stage]);
        foreach($stmt as $f){
            echo '<div class="file-box">
            <a href="'.$path.$f['file_path'].'" target="_blank" style="color:#fff;text-decoration:underline;">
            '.htmlspecialchars($f['file_path']).'
            </a>
            <small class="text-muted float-end">'.$f['uploaded_at'].'</small>
            </div>';
        }
    }
}
?>

<?php foreach($projects as $p): ?>
<div class="card mb-4">
<div class="card-header">
Project #<?= $p['id'] ?> — <?= htmlspecialchars($p['title']) ?>
</div>

<div class="card-body">

<!-- BASIC INFO -->
<div class="row">
<div class="col-md-4">
<b>Client</b><br>
<?= htmlspecialchars($p['client_name']) ?><br>
<?= htmlspecialchars($p['client_email']) ?><br>
<?= htmlspecialchars($p['client_phone']) ?>
</div>

<div class="col-md-4">
<b>Sales</b><br>
<?= htmlspecialchars($p['sales_name']) ?><br><br>
<b>Designer</b><br>
<?= htmlspecialchars($p['designer_name']) ?>
</div>

<div class="col-md-4">
<b>Price:</b> $<?= number_format($p['price'],2) ?><br>
<b>Received:</b> $<?= number_format($p['payment_received'],2) ?><br>
<b>Remaining:</b> $<?= number_format($p['payment_remaining'],2) ?><br>
<b>Tip:</b> $<?= number_format($p['tip_amount'],2) ?><br>
<b>Status:</b>
<span class="badge bg-success">Completed</span>
</div>
</div>

<hr>

<!-- DESCRIPTION -->
<div>
<b>Description</b><br>
<?= nl2br(htmlspecialchars($p['description'])) ?>
</div>

<!-- FILE SECTIONS -->
<h6 class="section-title">Client Files</h6>
<?php showFiles($pdo,$p['id'],'Client','../../employees/uploads/projects/'); ?>

<h6 class="section-title">Payment Screenshots</h6>
<?php showFiles($pdo,$p['id'],'Payment','../../employees/uploads/payments/'); ?>

<h6 class="section-title">Design Files</h6>
<?php showFiles($pdo,$p['id'],'Design','../../employees/uploads/designs/'); ?>

<h6 class="section-title">Final Files</h6>
<?php showFiles($pdo,$p['id'],'Final','../../employees/uploads/finals/'); ?>

<!-- ACTION LOG -->
<h6 class="section-title">Action History</h6>
<?php
$actions = $pdo->prepare("
    SELECT * FROM project_actions
    WHERE project_id=?
    ORDER BY created_at ASC
");
$actions->execute([$p['id']]);
foreach($actions as $a):
?>
<div class="action-box">
<b><?= htmlspecialchars($a['action_by']) ?>:</b>
<?= htmlspecialchars($a['action']) ?>
<small class="text-muted float-end">
<?= $a['created_at'] ?>
</small>
</div>
<?php endforeach; ?>

</div>
</div>
<?php endforeach; ?>

</div>
<script src="assets/particles.js"></script>
</body>
</html>
