<?php
session_start();
require '../config/db.php';

if(!isset($_SESSION['hr_id'])) die('Unauthorized');

$managerId = $_SESSION['hr_id'];

/* =============================== DEPARTMENT CONFIG ============================== */
$departments = [
    'Sales'       => 'sales',
    'Design'      => 'design',
    'Development' => 'development',
    'Marketing'   => 'marketing'
];

if($_POST){

    $deptKey   = $_POST['dept_key'];      // sales, design...
    $deptName  = $_POST['dept_name'];     // Sales, Design...
    $entryDate = $_POST['entry_date'];
    $entryTime = $_POST['entry_time'];

    $empTable   = $deptKey.'_employees';
    $entryTable = $deptKey.'_employee_entry_times';

    // Get all employees of department
    $employees = $pdo->query("SELECT id FROM $empTable")->fetchAll(PDO::FETCH_COLUMN);

    $insert = $pdo->prepare("
        INSERT IGNORE INTO $entryTable
        (department, employee_id, entry_date, entry_time, created_by_manager)
        VALUES (?,?,?,?,?)
    ");

    foreach($employees as $empId){
        $insert->execute([
            $deptName,
            $empId,
            $entryDate,
            $entryTime,
            $managerId
        ]);
    }

    $success = "Entry time applied for $deptName department.";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link rel="stylesheet" href="../assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
:root{
  
  --dark:#050814;
  --glass:rgba(255,255,255,.08);
}

/* RESET */
*{box-sizing:border-box;font-family:Inter,Segoe UI,Arial,sans-serif}
body{margin:0;}

/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 30%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 30s ease-in-out infinite alternate;
  z-index:-5;
}
@keyframes mesh{to{filter:hue-rotate(25deg)}}

.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-4;
}
@keyframes grid{to{transform:translateY(70px)}}

/* ===== TOPBAR ===== */
.topbar{
  position:fixed;top:0;left:0;right:0;
  height:64px;
  display:flex;
  align-items:center;
  justify-content:space-between;
  padding:0 32px;
  background:rgba(8,12,25,.6);
  backdrop-filter:blur(16px);
  border-bottom:1px solid rgba(255,255,255,.08);
  z-index:10;
}
.logo{font-weight:600;}
.status{
  font-size:13px;
  display:flex;
  align-items:center;
  gap:8px;
}
.status::before{
  content:"";
  width:9px;height:9px;
  background:#1cff7a;
  border-radius:50%;
  box-shadow:0 0 12px #1cff7a;
}

/* ===== GLASS PANEL ===== */
.glass-panel{
  margin:100px 28px 40px;
  padding:28px;
  background:var(--glass);
  backdrop-filter:blur(22px);
  border:1px solid rgba(255,255,255,.15);
  border-radius:20px;
  color:white;
  box-shadow:0 0 60px rgba(31,140,255,.25);
}

/* ===== CARD & FORM ===== */
.card{border-radius:16px ; color:white; background:rgba(255,255,255,.05);box-shadow:0 0 20px rgba(31,140,255,.2);}
.card-body label{font-weight:500;}
input.form-control{background:rgba(0,0,0,.3);border:1px solid rgba(255,255,255,.15);color:#fff;border-radius:10px;}
input.form-control:focus{outline:none;border-color:var(--blue);box-shadow:0 0 8px var(--blue);}
button.btn{background:linear-gradient(135deg,var(--blue),var(--orange));color:#fff;font-weight:600;transition:.3s;}
button.btn:hover{box-shadow:0 0 20px var(--blue);transform:translateY(-2px);}
</style>
</head>
<body>
<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<?php include '../assets/header.php'; ?>
  <div class="logo">Jillion <span style="color:var(--blue)">Gamuts</span></div>
  <div class="status">HR Control Online</div>
</div>

<div class="glass-panel">
<h3 class="mb-4 text-center">Department Entry Time Control</h3>

<?php if(!empty($success)): ?>
<div class="alert alert-success"><?= $success ?></div>
<?php endif; ?>

<div class="row">
<?php foreach($departments as $deptName => $deptKey): ?>
<div class="col-md-6 mb-4">
<div class="card">
<div class="card-body">

<h5 class="mb-3 text-uppercase"><?= $deptName ?></h5>

<form method="POST">
<input type="hidden" name="dept_key" value="<?= $deptKey ?>">
<input type="hidden" name="dept_name" value="<?= $deptName ?>">

<div class="mb-2">
<label>Date</label>
<input type="date" name="entry_date" class="form-control" required>
</div>

<div class="mb-2">
<label>Entry Time</label>
<input type="time" name="entry_time" class="form-control" required>
</div>

<button class="btn w-100">
Apply Entry Time to <?= $deptName ?>
</button>

</form>

</div>
</div>
</div>
<?php endforeach; ?>
</div>
</div>
<script src="../assets/particles.js"></script>
</body>
</html>
