<?php
session_start();
require '../config/db.php';

if(!isset($_SESSION['manager_id'])) die('Unauthorized');

$manager_id = $_SESSION['manager_id'];
$dept = $_SESSION['department'];

$leaveTable = $dept.'_manager_leaves';
$msgTable   = $dept.'_manager_leave_messages';

// Fetch leaves by status
$statuses = ['Pending', 'Approved', 'Rejected'];
$leavesData = [];

foreach($statuses as $status){
    $stmt = $pdo->prepare("
        SELECT * FROM $leaveTable
        WHERE manager_id=? AND status=?
        ORDER BY requested_on DESC
    ");
    $stmt->execute([$manager_id, $status]);
    $leavesData[$status] = $stmt->fetchAll(PDO::FETCH_ASSOC);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>My Leave Requests</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
.chat-box{background:#f8f9fa;padding:8px;border-radius:6px;font-size:14px;}
.chat-hr{color:#0d6efd;}
.chat-manager{color:#198754;}
</style>
</head>
<body>
<div class="container mt-4">
<h4 class="mb-4">My Leave Requests</h4>

<!-- TABS -->
<ul class="nav nav-tabs mb-3" role="tablist">
    <?php foreach($statuses as $i => $status): ?>
    <li class="nav-item">
        <button class="nav-link <?= $i==0?'active':'' ?>" data-bs-toggle="tab" data-bs-target="#<?= strtolower($status) ?>">
            <?= $status ?>
            <?php if(count($leavesData[$status])): ?>
                <span class="badge bg-danger"><?= count($leavesData[$status]) ?></span>
            <?php endif; ?>
        </button>
    </li>
    <?php endforeach; ?>
</ul>

<div class="tab-content">
<?php foreach($statuses as $i => $status): ?>
<div class="tab-pane fade <?= $i==0?'show active':'' ?>" id="<?= strtolower($status) ?>">
    <?php if(!$leavesData[$status]): ?>
        <div class="alert alert-info">No <?= strtolower($status) ?> leave requests.</div>
    <?php else: ?>
        <?php foreach($leavesData[$status] as $l): ?>
        <div class="card mb-3 shadow-sm">
        <div class="card-body">
            <p><b>Date:</b> <?= $l['leave_date'] ?></p>
            <p><b>Reason:</b> <?= htmlspecialchars($l['reason']) ?></p>
            <p>
                <b>Status:</b>
                <span class="badge <?= $status=='Approved'?'bg-success':($status=='Rejected'?'bg-danger':'bg-warning text-dark') ?>">
                    <?= $status ?>
                </span>
            </p>

            <!-- CHAT -->
            <div class="chat-box mb-2">
            <?php
            $msgs = $pdo->prepare("
                SELECT * FROM $msgTable
                WHERE leave_id=?
                ORDER BY created_at ASC
            ");
            $msgs->execute([$l['id']]);
            if($msgs->rowCount()==0){
                echo "<span class='text-muted'>No messages yet</span>";
            }else{
                foreach($msgs as $m){
                    $cls = ($m['sender']=='HR') ? 'chat-hr' : 'chat-manager';
                    echo "<div class='$cls'><b>{$m['sender']}:</b> ".htmlspecialchars($m['message'])."</div>";
                }
            }
            ?>
            </div>

            <!-- REPLY FORM (ONLY PENDING) -->
            <?php if($status=='Pending'): ?>
            <form method="POST" action="manager_reply_hr.php" class="d-flex gap-2">
                <input type="hidden" name="leave_id" value="<?= $l['id'] ?>">
                <input type="text" name="message" maxlength="25" class="form-control form-control-sm"
                       placeholder="Reply to HR (25 chars)" required>
                <button class="btn btn-sm btn-primary">Send</button>
            </form>
            <?php else: ?>
            <div class="text-muted">Messaging closed (Leave <?= $status ?>)</div>
            <?php endif; ?>

        </div>
        </div>
        <?php endforeach; ?>
    <?php endif; ?>
</div>
<?php endforeach; ?>
</div>

</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
