<?php
session_start();
require '../config/db.php';

$error = '';

if ($_POST) {
    $stmt = $pdo->prepare("
        SELECT * FROM managers
        WHERE email=? AND department='Design' AND status=1
    ");
    $stmt->execute([$_POST['email']]);
    $m = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($m && $m['password'] && password_verify($_POST['password'], $m['password'])) {

        session_regenerate_id(true);

        $_SESSION['manager_id'] = $m['id'];
        $_SESSION['department'] = $m['department'];
        $_SESSION['manager_name'] = $m['full_name'];

        // login log
        $pdo->prepare("
            INSERT INTO manager_login_logs
            (manager_id,department, login_date, login_time, ip_address)
            VALUES (?, ? ,CURDATE(), CURTIME(), ?)
        ")->execute([$m['id'],$m['department'], $_SERVER['REMOTE_ADDR']]);

        header("Location: dashboard.php");
        exit;
    }

    if ($m && $m['password'] === NULL) {
        $_SESSION['set_pass_id'] = $m['id'];
        header("Location: set_password.php");
        exit;
    }

    $error = "Invalid email or password";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Design Manager Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{
    background: linear-gradient(135deg, #0f2027, #203a43, #2c5364);
}
.login-card{
    border: none;
    border-radius: 6px;
}
</style>
</head>

<body class="d-flex align-items-center vh-100">

<div class="container">
 <div class="row justify-content-center">
  <div class="col-md-4">

   <div class="card login-card shadow">
    <div class="card-body p-4">

     <h4 class="text-center mb-3">Design Manager Login</h4>

     <?php if($error): ?>
      <div class="alert alert-danger"><?= $error ?></div>
     <?php endif; ?>

     <form method="POST" autocomplete="off">

      <div class="mb-3">
       <label class="form-label">Email</label>
       <input type="email" name="email" class="form-control" required>
      </div>

      <div class="mb-3">
       <label class="form-label">Password</label>
       <input type="password" name="password" class="form-control" required>
      </div>

      <button class="btn btn-dark w-100">Login</button>

     </form>

     <p class="text-muted text-center mt-3 mb-0" style="font-size:13px">
       First time login? You will be asked to set your password.
     </p>

    </div>
   </div>

  </div>
 </div>
</div>

</body>
</html>

