<?php
session_start();
require '../config/db.php';

if (!isset($_SESSION['manager_id'])) {
    die('Unauthorized');
}

$dept = 'Design';

// Fetch Pending Leaves (Manager action required)
$pending_stmt = $pdo->prepare("
    SELECT r.*, e.full_name
    FROM design_employee_leave_requests r
    JOIN {$dept}_employees e ON r.employee_id = e.id
    WHERE r.status = 'Pending'
    ORDER BY r.created_at ASC
");
$pending_stmt->execute();
$pending_requests = $pending_stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch Manager Approved Leaves (HR action pending)
$hr_pending_stmt = $pdo->prepare("
    SELECT r.*, e.full_name
    FROM design_employee_leave_requests r
    JOIN {$dept}_employees e ON r.employee_id = e.id
    WHERE r.status = 'ManagerApproved'
    ORDER BY r.leave_date ASC
");
$hr_pending_stmt->execute();
$hr_pending_requests = $hr_pending_stmt->fetchAll(PDO::FETCH_ASSOC);

$hr_approve_stmt = $pdo->prepare("
    SELECT r.*, e.full_name
    FROM design_employee_leave_requests r
    JOIN {$dept}_employees e ON r.employee_id = e.id
    WHERE r.status = 'HRApproved'
    ORDER BY r.leave_date ASC
");
$hr_approve_stmt->execute();
$hr_approve_requests = $hr_approve_stmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch Rejected Leaves
$rejected_stmt = $pdo->prepare("
    SELECT r.*, e.full_name
    FROM design_employee_leave_requests r
    JOIN {$dept}_employees e ON r.employee_id = e.id
    WHERE r.status = 'Rejected'
    ORDER BY r.leave_date DESC
");
$rejected_stmt->execute();
$rejected_requests = $rejected_stmt->fetchAll(PDO::FETCH_ASSOC);


?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($dept) ?> Manager – Leave Requests</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{ background:#f4f6f9; }
.chat-box{ background:#fff; border:1px solid #dee2e6; padding:10px; max-height:180px; overflow-y:auto; font-size:14px; }
.chat-employee{ color:#0d6efd; }
.chat-manager{ color:#dc3545; }
</style>
</head>
<body>

<nav class="navbar navbar-dark bg-dark px-4">
    <span class="navbar-brand"><?= htmlspecialchars($dept) ?> Manager – Leave Requests</span>
    <a href="dashboard.php" class="btn btn-sm btn-secondary">Dashboard</a>
</nav>

<div class="container mt-4">

<!-- Tabs -->
<ul class="nav nav-tabs mb-3" id="leaveTab" role="tablist">
  <li class="nav-item">
    <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#pending">Pending</button>
  </li>
  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#hr">HR Pending</button>
  </li>
  <li class="nav-item">
    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#approve">Approved</button>
  </li>
  <li class="nav-item">
    <button class="nav-link text-danger" data-bs-toggle="tab" data-bs-target="#rejected">Rejected</button>
  </li>
</ul>


<div class="tab-content">
<!-- PENDING TAB -->
<div class="tab-pane fade show active" id="pending" role="tabpanel">
<?php if(!$pending_requests): ?>
    <div class="alert alert-info">No pending leave requests for your approval.</div>
<?php else: ?>
<?php foreach($pending_requests as $r): ?>
<div class="card shadow-sm mb-4">
<div class="card-body">

    <h5><?= htmlspecialchars($r['full_name']) ?></h5>
    <p class="text-muted mb-1">
        Leave Date: <strong><?= htmlspecialchars($r['leave_date']) ?></strong>
    </p>

    <div class="alert alert-secondary p-2 mb-2">
        <strong>Reason:</strong><br>
        <?= htmlspecialchars($r['reason']) ?>
    </div>

    <!-- Conversation -->
    <div class="chat-box mb-2">
    <?php
    $msgs = $pdo->prepare("SELECT * FROM design_leave_messages WHERE leave_id=? ORDER BY created_at ASC");
    $msgs->execute([$r['id']]);

    if($msgs->rowCount()==0){
        echo '<span class="text-muted">No conversation yet.</span>';
    } else {
        foreach($msgs as $m){
            $cls = $m['sender']=='Manager' ? 'chat-manager' : 'chat-employee';
            echo "<div class='$cls'><b>{$m['sender']}:</b> ".htmlspecialchars($m['message'])."</div>";
        }
    }
    ?>
    </div>

    <!-- Ask Question -->
    <form method="POST" action="send_message.php" class="d-flex gap-2 mb-2">
        <input type="hidden" name="leave_id" value="<?= $r['id'] ?>">
        <input type="text" name="message" class="form-control form-control-sm"
               maxlength="25" placeholder="Ask (max 25 chars)" required>
        <button class="btn btn-warning btn-sm">Send</button>
    </form>

    <!-- Approve + Reject -->
    <div class="d-flex gap-2">

        <!-- APPROVE -->
        <form method="POST" action="approve_leave.php"
              onsubmit="return confirm('Approve this leave and send to HR?')">
            <input type="hidden" name="id" value="<?= $r['id'] ?>">
            <button class="btn btn-success btn-sm">
                Approve
            </button>
        </form>

        <!-- REJECT -->
        <form method="POST" action="reject_leave.php"
              onsubmit="return confirm('Reject this leave request?')">
            <input type="hidden" name="id" value="<?= $r['id'] ?>">
            <button class="btn btn-danger btn-sm">
                Reject
            </button>
        </form>

    </div>

</div>
</div>
<?php endforeach; ?>
<?php endif; ?>
</div>

  <!-- HR PENDING TAB -->
  <div class="tab-pane fade" id="hr" role="tabpanel">
    <?php if(!$hr_pending_requests): ?>
        <div class="alert alert-info">No leaves approved by you pending HR finalization.</div>
    <?php else: ?>
        <?php foreach($hr_pending_requests as $r): ?>
        <div class="card shadow-sm mb-4">
        <div class="card-body">
            <h5><?= htmlspecialchars($r['full_name']) ?></h5>
            <p class="text-muted mb-1">Leave Date: <strong><?= htmlspecialchars($r['leave_date']) ?></strong></p>
            <div class="alert alert-secondary p-2 mb-2">
                <strong>Reason:</strong><br><?= htmlspecialchars($r['reason']) ?>
            </div>

            <!-- Conversation -->
            <div class="chat-box mb-2">
            <?php
            $msgs = $pdo->prepare("SELECT * FROM design_leave_messages WHERE leave_id=? ORDER BY created_at ASC");
            $msgs->execute([$r['id']]);
            if($msgs->rowCount()==0){ echo '<span class="text-muted">No conversation yet.</span>'; }
            else{
                foreach($msgs as $m){
                    $cls = $m['sender']=='Manager'?'chat-manager':'chat-employee';
                    echo "<div class='$cls'><b>{$m['sender']}:</b> ".htmlspecialchars($m['message'])."</div>";
                }
            }
            ?>
            </div>
        </div>
        </div>
        <?php endforeach; ?>
    <?php endif; ?>
  </div>
  
  <!-- HR PENDING TAB -->
  <div class="tab-pane fade" id="approve" role="tabpanel">
    <?php if(!$hr_approve_requests): ?>
        <div class="alert alert-info">No leaves approved by you pending HR finalization.</div>
    <?php else: ?>
        <?php foreach($hr_approve_requests as $r): ?>
        <div class="card shadow-sm mb-4">
        <div class="card-body">
            <h5><?= htmlspecialchars($r['full_name']) ?></h5>
            <p class="text-muted mb-1">Leave Date: <strong><?= htmlspecialchars($r['leave_date']) ?></strong></p>
            <div class="alert alert-secondary p-2 mb-2">
                <strong>Reason:</strong><br><?= htmlspecialchars($r['reason']) ?>
            </div>

            <!-- Conversation -->
            <div class="chat-box mb-2">
            <?php
            $msgs = $pdo->prepare("SELECT * FROM design_leave_messages WHERE leave_id=? ORDER BY created_at ASC");
            $msgs->execute([$r['id']]);
            if($msgs->rowCount()==0){ echo '<span class="text-muted">No conversation yet.</span>'; }
            else{
                foreach($msgs as $m){
                    $cls = $m['sender']=='Manager'?'chat-manager':'chat-employee';
                    echo "<div class='$cls'><b>{$m['sender']}:</b> ".htmlspecialchars($m['message'])."</div>";
                }
            }
            ?>
            </div>
        </div>
        </div>
        <?php endforeach; ?>
    <?php endif; ?>
  </div>
<!-- REJECTED TAB -->
<div class="tab-pane fade" id="rejected" role="tabpanel">

<?php if(!$rejected_requests): ?>
    <div class="alert alert-info">No rejected leave requests.</div>
<?php else: ?>

<?php foreach($rejected_requests as $r): ?>
<div class="card shadow-sm mb-4 border-danger">
<div class="card-body">

    <h5><?= htmlspecialchars($r['full_name']) ?></h5>

    <p class="text-muted mb-1">
        Leave Date: <strong><?= htmlspecialchars($r['leave_date']) ?></strong>
    </p>

    <span class="badge bg-danger mb-2">Rejected</span>

    <div class="alert alert-secondary p-2 mb-2">
        <strong>Reason:</strong><br>
        <?= htmlspecialchars($r['reason']) ?>
    </div>

    <!-- Conversation -->
    <div class="chat-box">
    <?php
    $msgs = $pdo->prepare("
        SELECT * FROM design_leave_messages 
        WHERE leave_id=? 
        ORDER BY created_at ASC
    ");
    $msgs->execute([$r['id']]);

    if($msgs->rowCount()==0){
        echo '<span class="text-muted">No conversation.</span>';
    } else {
        foreach($msgs as $m){
            $cls = $m['sender']=='Manager'?'chat-manager':'chat-employee';
            echo "<div class='$cls'><b>{$m['sender']}:</b> ".htmlspecialchars($m['message'])."</div>";
        }
    }
    ?>
    </div>

</div>
</div>
<?php endforeach; ?>

<?php endif; ?>
</div>

</div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
