<?php
require '../config/db.php';

/* ================= DEFAULT MONTH & YEAR ================= */
$month = $_POST['month'] ?? date('n');
$year  = $_POST['year']  ?? date('Y');

/* ================= DESIGNERS ================= */
$designers = $pdo->query("
    SELECT id, full_name 
    FROM design_employees 
    ORDER BY full_name
")->fetchAll(PDO::FETCH_ASSOC);

/* ================= SAVE KPI ================= */
$msg = '';
if(isset($_POST['save_kpi'])){

    $designer_id   = $_POST['designer_id'];
    $designer_name = $_POST['designer_name'];

    /* ===== Attendance (6) ===== */
    $stmt = $pdo->prepare("
        SELECT COUNT(*) 
        FROM design_employee_attendance
        WHERE employee_id=? 
        AND MONTH(att_date)=? 
        AND YEAR(att_date)=?
        AND status='Present'
    ");
    $stmt->execute([$designer_id,$month,$year]);
    $presentDays = (int)$stmt->fetchColumn();

    $daysInMonth = cal_days_in_month(CAL_GREGORIAN,$month,$year);
    $attendancePercent = ($daysInMonth>0) ? ($presentDays/$daysInMonth)*100 : 0;

    if($attendancePercent >= 86) $attendance = 6;
    elseif($attendancePercent >= 76) $attendance = 5;
    elseif($attendancePercent >= 66) $attendance = 4;
    elseif($attendancePercent >= 51) $attendance = 3;
    elseif($attendancePercent >= 31) $attendance = 2;
    elseif($attendancePercent >= 1)  $attendance = 1;
    else $attendance = 0;

    /* ===== Punctuality (4) ===== */
    $lateStmt = $pdo->prepare("
        SELECT COUNT(*) 
        FROM design_employee_late_log
        WHERE employee_id=? 
        AND MONTH(log_date)=? 
        AND YEAR(log_date)=?
    ");
    $lateStmt->execute([$designer_id,$month,$year]);
    $late = (int)$lateStmt->fetchColumn();

    if($late == 0) $punctuality = 4;
    elseif($late == 1) $punctuality = 3;
    elseif($late == 2) $punctuality = 2;
    elseif($late == 3) $punctuality = 1;
    else $punctuality = 0;

    /* ===== Manual Behavior (15) ===== */
    $communication     = min(max($_POST['communication'],0),3);
    $team_coordination = min(max($_POST['team_coordination'],0),3);
    $overtime          = min(max($_POST['overtime'],0),4);
    $crm_discipline    = min(max($_POST['crm_discipline'],0),3);
    $professionalism   = min(max($_POST['professionalism'],0),2);

    /* ===== TOTAL BEHAVIOR ===== */
    $total = $punctuality + $attendance + $communication + $team_coordination + $overtime + $crm_discipline + $professionalism;

    /* ===== UPSERT INTO DB ===== */
    $save = $pdo->prepare("
        INSERT INTO design_behavior_kpi
        (designer_id, designer_name, month, year,
         punctuality, attendance,
         communication, team_coordination, overtime,
         crm_discipline, professionalism, total_behavior)
        VALUES (?,?,?,?,?,?,?,?,?,?,?,?)
        ON DUPLICATE KEY UPDATE
            punctuality=VALUES(punctuality),
            attendance=VALUES(attendance),
            communication=VALUES(communication),
            team_coordination=VALUES(team_coordination),
            overtime=VALUES(overtime),
            crm_discipline=VALUES(crm_discipline),
            professionalism=VALUES(professionalism),
            total_behavior=VALUES(total_behavior),
            updated_at=CURRENT_TIMESTAMP
    ");
    $save->execute([
        $designer_id, $designer_name, $month, $year,
        $punctuality, $attendance,
        $communication, $team_coordination, $overtime,
        $crm_discipline, $professionalism, $total
    ]);

    $msg = "✅ Behavior KPI Successfully Saved!";
    // FORM CLEAR
    $_POST = [];
}
?>

<!DOCTYPE html>
<html>
<head>
<title>Design Behavior KPI Entry</title>
<style>
body{font-family:Arial;background:#f1f5f9}
.box{max-width:700px;margin:30px auto;background:#fff;padding:25px;border-radius:16px;box-shadow:0 5px 15px rgba(0,0,0,.1)}
h2{margin-bottom:20px;text-align:center}
label{font-weight:bold;margin-top:10px;display:block}
input,select,button{width:100%;padding:10px;margin-top:6px;border-radius:6px;border:1px solid #ccc}
button{background:#2563eb;color:#fff;border:none;font-size:16px;margin-top:15px;cursor:pointer}
.success{color:green;font-weight:bold;margin-bottom:10px;text-align:center}
</style>
</head>
<body>

<div class="box">
<h2>🎨 Enter Design Behavior KPI</h2>

<?php if($msg): ?>
<div class="success"><?=$msg?></div>
<?php endif; ?>

<form method="post">
<label>Designer</label>
<select name="designer_id" required onchange="this.form.designer_name.value=this.options[this.selectedIndex].text">
<option value="">Select Designer</option>
<?php foreach($designers as $d): ?>
<option value="<?=$d['id']?>" <?=($_POST['designer_id']??'')==$d['id']?'selected':''?>><?=$d['full_name']?></option>
<?php endforeach; ?>
</select>
<input type="hidden" name="designer_name">

<label>Month</label>
<input type="number" name="month" min="1" max="12" value="<?=htmlspecialchars($_POST['month'] ?? $month)?>">

<label>Year</label>
<input type="number" name="year" value="<?=htmlspecialchars($_POST['year'] ?? $year)?>">

<h3>Manual Behavior</h3>
<input type="number" name="communication" placeholder="Communication (0–3)" value="<?=htmlspecialchars($_POST['communication'] ?? '')?>">
<input type="number" name="team_coordination" placeholder="Team Coordination (0–3)" value="<?=htmlspecialchars($_POST['team_coordination'] ?? '')?>">
<input type="number" name="overtime" placeholder="Overtime (0–4)" value="<?=htmlspecialchars($_POST['overtime'] ?? '')?>">
<input type="number" name="crm_discipline" placeholder="CRM Discipline (0–3)" value="<?=htmlspecialchars($_POST['crm_discipline'] ?? '')?>">
<input type="number" name="professionalism" placeholder="Professionalism (0–2)" value="<?=htmlspecialchars($_POST['professionalism'] ?? '')?>">

<button name="save_kpi">Save KPI</button>
</form>
</div>

</body>
</html>
