<?php
session_start();
if (!isset($_SESSION['manager_id'])) {
    die('Unauthorized');
}
if (!isset($_SESSION['department']) || $_SESSION['department'] !== 'Design') {
    header('Location: login.php');
    exit;
}
require '../config/db.php';
$dept = 'Design';

// Count pending leave requests for this manager's department
$stmt = $pdo->prepare("
    SELECT COUNT(*) as pending_count 
    FROM design_employee_leave_requests r
    JOIN ".$dept."_employees e ON r.employee_id = e.id
    WHERE r.status='Pending'
");
$stmt->execute();
$pending_count = $stmt->fetchColumn();
$manager_id = $_SESSION['manager_id'];
$manager_table = "manager2_attendance";

$today = date('Y-m-d');

// Check if today attendance exists
$stmt = $pdo->prepare("SELECT * FROM $manager_table WHERE manager_id=? AND att_date=?");
$stmt->execute([$manager_id, $today]);
$today_att = $stmt->fetch();

?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($dept) ?> Manager Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{
    background-color: #f4f6f9;
}
.card{
    border-radius: 6px;
}
</style>
</head>

<body>

<!-- NAVBAR -->
<nav class="navbar navbar-dark bg-dark px-4">
    <span class="navbar-brand"><?= htmlspecialchars($dept) ?> Manager Panel</span>
    <div>
        <span class="text-white me-3"><?= htmlspecialchars($_SESSION['department']) ?> Manager</span>
        <a href="logout.php" class="btn btn-sm btn-danger">Logout</a>
    </div>
</nav>

<!-- MAIN CONTENT -->
<div class="container mt-4">

    <div class="row">
        <div class="col-md-6">
            <div class="card shadow-sm mb-4">
                <div class="card-body d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="mb-1">Welcome, <?= htmlspecialchars($_SESSION['department']) ?> Manager</h4>
                        <p class="text-muted mb-0">Department: <?= htmlspecialchars($_SESSION['department']) ?></p>
                    </div>
                    <!-- Pending Leave Requests Button -->
                   
                </div>
            </div>
        </div>
    </div>

    <!-- INFO CARDS -->
    <div class="row">

        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h6>Total Team Members</h6>
                    <h3>0</h3>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h6>Monthly Targets</h6>
                    <h3>0</h3>
                </div>
            </div>
        </div>

        <div class="col-md-4">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h6>Completed Deals</h6>
                    <h3>0</h3>
                </div>
            </div>
        </div>

    </div>
<div>
    <a href="leave_requests.php" class="btn btn-sm btn-warning">
        Pending Leave Requests
        <?php if($pending_count > 0): ?>
            <span class="badge bg-danger ms-1">
                <?= (int)$pending_count ?>
            </span>
        <?php endif; ?>
    </a>
</div>
<div class="container mt-4">

<?php if(!$today_att): ?>
<div class="alert alert-warning d-flex justify-content-between align-items-center">
    You have not marked attendance today!
    <form method="POST" action="mark_attendance.php">
        <button class="btn btn-success btn-sm">Mark Today</button>
    </form>
</div>
<?php endif; ?>

<div class="mb-3">
    <a href="my_attendance.php" class="btn btn-outline-primary">
        My Attendance
    </a>
</div>
<div class="mb-3">
    <a href="manager_request_attendance.php" class="btn btn-warning">
        Request Missing Attendance
    </a>
</div>
<div class="mb-3">
    <a href="my_leaves.php" class="btn btn-outline-primary">
        My Leave Requests
    </a>
</div>
<div class="mb-3">
    <a href="manager_apply_leave.php" class="btn btn-outline-primary">
        Apply Leave Requests
    </a>
</div>
<div class="mb-3">
    <a href="set_entry_time.php" class="btn btn-outline-primary">
        Set Entry Time
    </a>
</div>
<div class="stat-card shadow-soft">
                <a href="project_assign.php" class="btn btn-info btn-rounded mb-4">
            <i class="fa-solid fa-plus"></i> Assign Designer
        </a>
            </div>
            <div class="stat-card shadow-soft">
                <a href="design_kpi_entry.php" class="btn btn-info btn-rounded mb-4">
            <i class="fa-solid fa-plus"></i> designer Kpi
        </a>
            </div>
             <div class="stat-card shadow-soft">
                <a href="design_kpi_view.php" class="btn btn-info btn-rounded mb-4">
            <i class="fa-solid fa-plus"></i> designer Kpi View
        </a>
            </div>
</div>

</div>

</body>
</html>
