<?php
session_start();
require '../config/db.php';

if(!isset($_SESSION['employee_id'])) die('Unauthorized');

$designer_id = $_SESSION['employee_id'];

/* ===============================
   FINAL FILE UPLOAD (UNCHANGED)
================================ */
if(isset($_POST['upload_final'])){
    $project_id = $_POST['project_id'];

    foreach($_FILES['final_files']['name'] as $i => $name){
        if($_FILES['final_files']['error'][$i] === 0){
            $tmp  = $_FILES['final_files']['tmp_name'][$i];
            $file = time().'_'.$name;
            move_uploaded_file($tmp,"../uploads/finals/".$file);

            $pdo->prepare("
                INSERT INTO project_files
                (project_id, uploaded_by, file_stage, file_path)
                VALUES (?,?,?,?)
            ")->execute([
                $project_id,
                'Designer',
                'Final',
                $file
            ]);
        }
    }

    $pdo->prepare("
        UPDATE projects
        SET status='FinalFilesUploaded'
        WHERE id=? AND designer_id=?
    ")->execute([$project_id,$designer_id]);

    $pdo->prepare("
        INSERT INTO project_actions
        (project_id, action_by, action)
        VALUES (?,?,?)
    ")->execute([
        $project_id,
        'Designer',
        'Final files uploaded'
    ]);
}

/* ===============================
   FETCH PROJECTS (UNCHANGED)
================================ */
$stmt = $pdo->prepare("
    SELECT * FROM projects
    WHERE designer_id=?
    AND status='DesignFinalApproved'
    ORDER BY created_at DESC
");
$stmt->execute([$designer_id]);
$projects = $stmt->fetchAll(PDO::FETCH_ASSOC);

/* ===== PAGE TITLE ===== */
$page_title = "Designer • Final Files Upload";

/* ===== LAYOUT START ===== */
include 'assets/layout_top.php';
?>
<br><br><br>
<h3 class="text-center mb-4">
  <i class="fa-solid fa-cloud-arrow-up me-2"></i>
  Final Approved Projects
</h3>

<?php if(!$projects): ?>
<div class="glass-card text-center">
  <i class="fa-solid fa-circle-info fa-2x mb-2"></i>
  <p class="mb-0">No projects ready for final files</p>
</div>
<?php endif; ?>

<?php foreach($projects as $p): ?>
<div class="glass-card">

  <h5 class="mb-3">
    <i class="fa-solid fa-folder-open me-2"></i>
    <?= htmlspecialchars($p['title']) ?>
    <span class="badge bg-success ms-2">Final Approved</span>
  </h5>

  <div class="row mb-3">
    <div class="col-md-6">
      <p><i class="fa-solid fa-user me-1"></i> <b>Client:</b> <?= htmlspecialchars($p['client_name']) ?></p>
      <p><i class="fa-solid fa-user-tie me-1"></i> <b>Sales:</b> <?= htmlspecialchars($p['sales_name']) ?></p>
    </div>
    <div class="col-md-6">
      <b>Description:</b><br>
      <?= nl2br(htmlspecialchars($p['description'])) ?>
    </div>
  </div>

  <hr>

  <!-- FILE HISTORY -->
  <h6 class="mb-2">
    <i class="fa-solid fa-paperclip me-1"></i>
    Previous Files
  </h6>

  <?php
  $files = $pdo->prepare("
      SELECT * FROM project_files
      WHERE project_id=? AND file_stage IN ('Design','Client')
  ");
  $files->execute([$p['id']]);
  foreach($files as $f):
  ?>
    <div class="file-box mb-1">
      <a href="../uploads/<?= strtolower($f['file_stage']) ?>s/<?= $f['file_path'] ?>" target="_blank">
        <i class="fa-solid fa-file-lines me-1"></i>
        <?= htmlspecialchars($f['file_path']) ?>
      </a>
      <span class="text-muted"> (<?= $f['file_stage'] ?>)</span>
    </div>
  <?php endforeach; ?>

  <hr>

  <!-- SALES COMMENT -->
  <h6><i class="fa-solid fa-comment-dots me-1"></i> Sales Comment</h6>
  <div class="alert alert-warning">
    <?= nl2br(htmlspecialchars($p['comments'] ?? 'No comment provided')) ?>
  </div>

  <hr>

  <!-- UPLOAD FINAL -->
  <h6><i class="fa-solid fa-upload me-1"></i> Upload Final Files</h6>
  <form method="POST" enctype="multipart/form-data">
    <input type="hidden" name="project_id" value="<?= $p['id'] ?>">
    <input type="file" name="final_files[]" multiple required class="form-control mb-3">
    <button name="upload_final" class="btn-main">
      <i class="fa-solid fa-cloud-arrow-up me-1"></i>
      Upload Final Files
    </button>
  </form>

</div>
<?php endforeach; ?>

<?php
/* ===== LAYOUT END ===== */
include 'assets/layout_bottom.php';
?>
