<?php
session_start();
require '../config/db.php';
if(!isset($_SESSION['employee_id'])) die('Unauthorized');

if($_SERVER['REQUEST_METHOD'] == 'POST'){
    $date = $_POST['req_date'];
    $reason = $_POST['reason'];
    $emp_id = $_SESSION['employee_id'];
    $dept = $_SESSION['department'];

    $stmt = $pdo->prepare("INSERT INTO attendance_requests (employee_id, department, req_date, reason) VALUES (?,?,?,?)");
    $stmt->execute([$emp_id, $dept, $date, $reason]);
    header("Location: dashboard.php?msg=Request Submitted");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<!-- External CSS -->
<link rel="stylesheet" href="assets/style.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}
@keyframes grid{to{transform:translateY(70px)}}

/* Glass panel */
.glass-panel{
  max-width:600px;
  margin:100px auto;
  padding:30px;
  background:rgba(255,255,255,.08);
  backdrop-filter:blur(22px);
  border-radius:18px;
  border:1px solid rgba(255,255,255,.14);
  box-shadow:0 12px 35px rgba(0,151,252,.25);
  color:#fff;
}

/* Form inputs */
.form-control, textarea{
  background:rgba(0,0,0,.35);
  border:1px solid rgba(255,255,255,.15);
  color:#fff;
}
.form-control:focus, textarea:focus{
  border-color:#0097fc;
  box-shadow:0 0 0 1px #0097fc, 0 0 18px rgba(0,151,252,.45);
  background:rgba(0,0,0,.4);
  color:#fff;
}
textarea{resize:none}

/* Labels */
label{font-size:13px;opacity:.8;color:#fff}

/* Buttons */
.btn-main{
  background:linear-gradient(135deg,#0097fc,#ff6a00);
  border:none;
  color:#fff;
  font-weight:600;
  padding:12px;
  box-shadow:0 0 25px rgba(0,151,252,.4);
  transition:.3s;
}
.btn-main:hover{
  transform:translateY(-2px);
  box-shadow:0 0 35px rgba(255,138,0,.6);
}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<!-- ===== HEADER ===== -->
<?php include 'assets/header.php'; ?>

<!-- ===== ATTENDANCE REQUEST FORM ===== -->
<div class="glass-panel">

<h4 class="mb-4 text-center">Request Missing Attendance</h4>

<form method="POST">

    <div class="mb-3">
        <label for="req_date">Date of Attendance</label>
        <input type="date" name="req_date" id="req_date" class="form-control" required max="<?= date('Y-m-d') ?>">
    </div>

    <div class="mb-3">
        <label for="reason">Reason</label>
        <textarea name="reason" id="reason" class="form-control" rows="4" required></textarea>
    </div>

    <div class="d-grid">
        <button class="btn-main" type="submit">Submit Request</button>
    </div>

</form>

</div>

<script src="assets/particles.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
