<?php
session_start();
require '../config/db.php';
if(!isset($_SESSION['employee_id'])) die('Unauthorized');

$sales_id = $_SESSION['employee_id'];

/* ===============================
   DESIGN REVIEW ACTION
================================ */
if(isset($_POST['action_design'])){
    $project_id = (int)$_POST['project_id'];
    $action     = $_POST['action_design'] ?? null;
    $comment    = $_POST['comment'] ?? '';

    if($action){

        /* ===== APPROVE ===== */
        if($action === 'approve'){
            $pdo->prepare("UPDATE projects SET status='DesignFinalApproved' WHERE id=?")
                ->execute([$project_id]);
            $pdo->prepare("INSERT INTO project_actions (project_id, action_by, action) VALUES (?,?,?)")
                ->execute([$project_id,'Sales','Design approved by Sales']);
        }

        /* ===== REVISION REQUEST ===== */
        elseif($action === 'revision'){
            $pdo->prepare("UPDATE projects SET status='RevisionRequested', comments=?, revision_count = revision_count + 1 WHERE id=?")
                ->execute([$comment,$project_id]);
            $pdo->prepare("INSERT INTO project_actions (project_id, action_by, action) VALUES (?,?,?)")
                ->execute([$project_id,'Sales','Revision requested']);
        }
    }
}

/* ===============================
   FETCH PROJECTS WITH DESIGN UPLOADS
================================ */
$stmt = $pdo->prepare("SELECT * FROM projects WHERE sales_id=? AND status IN ('DesignUploaded','RevisionRequested') ORDER BY created_at DESC");
$stmt->execute([$sales_id]);
$projects = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<link rel="icon" type="image/png" href="images/jg.webp">
<title>JG - Suite</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- ===== External CSS ===== -->
<link rel="stylesheet" href="assets/style.css">

<style>
/* ===== Animated Background ===== */
.mesh{
  position:fixed;inset:0;
  background:
    radial-gradient(circle at 15% 20%, rgba(31,140,255,.35), transparent 45%),
    radial-gradient(circle at 80% 25%, rgba(255,138,0,.28), transparent 45%),
    linear-gradient(180deg,#03040a,#070b18);
  animation:mesh 25s ease-in-out infinite alternate;
  z-index:-6;
}
@keyframes mesh{0%{filter:hue-rotate(0)}100%{filter:hue-rotate(25deg)}}

.grid{
  position:fixed;inset:0;
  background:
    linear-gradient(rgba(255,255,255,.04) 1px, transparent 1px),
    linear-gradient(90deg, rgba(255,255,255,.04) 1px, transparent 1px);
  background-size:70px 70px;
  animation:grid 50s linear infinite;
  z-index:-5;
}

/* Glass card */
.glass-card{
  background:rgba(255,255,255,.08);
  backdrop-filter:blur(22px);
  border-radius:18px;
  border:1px solid rgba(255,255,255,.14);
  box-shadow:0 12px 35px rgba(0,151,252,.25);
  padding:20px;
  margin-bottom:30px;
  color:#fff;
}

/* Headings */
h3,h6{color:#fff}

/* Designer file box */
.file-box{
  background:rgba(0,0,0,.3);
  padding:6px 10px;
  margin-bottom:6px;
  border-left:4px solid #0097fc;
  border-radius:4px;
}
.file-box a{color:#fff;text-decoration:none}
.file-box a:hover{text-decoration:underline}

/* Buttons */
.btn-main{
  background:linear-gradient(135deg,#0097fc,#ff6a00);
  border:none;color:#fff;font-weight:600;padding:8px 14px;
  box-shadow:0 0 20px rgba(0,151,252,.4);
  transition:.3s;margin-right:6px;
}
.btn-main:hover{
  transform:translateY(-2px);
  box-shadow:0 0 30px rgba(255,138,0,.6);
}

/* Textarea */
textarea{background:rgba(0,0,0,.35);border:1px solid rgba(255,255,255,.15);color:#fff;}
textarea:focus{border-color:#0097fc;box-shadow:0 0 0 1px #0097fc,0 0 15px rgba(0,151,252,.4);background:rgba(0,0,0,.4);color:#fff;}
</style>
</head>
<body>

<div class="mesh"></div>
<div class="grid"></div>
<canvas id="particles"></canvas>

<!-- ===== HEADER ===== -->
<?php include 'assets/header.php'; ?>

<div class="container mt-4">
<h3 class="mb-4 text-center">Designer Uploaded Files - Review</h3>

<?php if(!$projects): ?>
<div class="alert alert-info">No projects to review</div>
<?php endif; ?>

<?php foreach($projects as $p): ?>
<div class="glass-card">

<h5><?= htmlspecialchars($p['title']) ?> (Status: <?= $p['status'] ?>)</h5>

<div class="row mb-3">
<div class="col-md-6">
<b>Client:</b> <?= htmlspecialchars($p['client_name']) ?><br>
<b>Designer:</b> <?= htmlspecialchars($p['designer_name']) ?><br>
<b>Price:</b> $<?= $p['price'] ?><br>
<b>Tip:</b> $<?= $p['tip_amount'] ?>
</div>
<div class="col-md-6">
<b>Description:</b><br>
<?= nl2br(htmlspecialchars($p['description'])) ?>
</div>
</div>

<h6 class="mb-2">Designer Files</h6>
<?php
$designFiles = $pdo->prepare("SELECT * FROM project_files WHERE project_id=? AND uploaded_by='Designer' AND file_stage='Design'");
$designFiles->execute([$p['id']]);
if($designFiles->rowCount()==0){
    echo "<div class='text-muted'>No design files uploaded yet</div>";
}
foreach($designFiles as $f):
?>
<div class="file-box">
<a href="../uploads/designs/<?= htmlspecialchars($f['file_path']) ?>" target="_blank"><?= htmlspecialchars($f['file_path']) ?></a>
</div>
<?php endforeach; ?>

<h6 class="mt-3">Actions</h6>
<form method="POST">
<input type="hidden" name="project_id" value="<?= $p['id'] ?>">
<div class="mb-2">
<textarea name="comment" placeholder="Comment" rows="2"></textarea>
</div>
<button type="submit" name="action_design" value="approve" class="btn-main">Approve Design</button>
<button type="submit" name="action_design" value="revision" class="btn-main">Request Revision</button>
</form>

</div>
<?php endforeach; ?>

</div>

<script src="assets/particles.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
